###
###

.pkgname <- "BSgenome.Ppaniscus.UCSC.panPan1"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Pan paniscus",
        common_name="Bonobo",
        provider="UCSC",
        provider_version="panPan1",
        release_date="May 2012",
        release_name="Max-Planck Institute panpan1",
        source_url="https://hgdownload.cse.ucsc.edu/goldenPath/panPan1/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ppaniscus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

