###
###

.pkgname <- "BSgenome.Cfamiliaris.UCSC.canFam3"

.seqnames <- paste("chr", c(1:38, "X", "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- "chrUn"

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Canis lupus familiaris",
        species="Dog",
        provider="UCSC",
        provider_version="canFam3",
        release_date="Sep. 2011",
        release_name="Broad Institute v3.1",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/canFam3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Cfamiliaris"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

