% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{rowWeightedMeans}
\alias{rowWeightedMeans}
\alias{rowWeightedMeans,Zi-method}
\alias{colWeightedMeans}
\alias{colWeightedMeans,Zi-method}
\title{Row and Column weighted means of zero inflated count data}
\usage{
\S4method{rowWeightedMeans}{Zi}(
  x,
  w,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  useNames = TRUE
)

\S4method{colWeightedMeans}{Zi}(
  x,
  w,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  useNames = TRUE
)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{w}{a numerical vector of weights either of length = rows or length =
cols giving the weights to use for elements of x}

\item{rows, cols}{A \code{\link[base]{vector}} indicating the subset of rows
and/or columns to operate over. If \code{\link{NULL}} (default), no subsetting
is done}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}}
\code{\link{NA}}s are excluded, otherwise not. default = \code{\link{FALSE}}}

\item{useNames}{\code{\link[base]{logical}}  If \code{\link{TRUE}} (default),
names attributes of result are set. Else if \code{\link{FALSE}}, no naming
support is done.}
}
\value{
a numeric vector of length N(K)
}
\description{
Calculate row and column weighted means of zero inflated count
data, additionally taking weights for structural zeros into account.
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
rowWeightedMeans(Zi, w = runif(ncol(inputcounts(Zi)), 0.1,1))
colWeightedMeans(Zi, w = runif(nrow(inputcounts(Zi)), 0.1,1))

}
