% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{rowVars}
\alias{rowVars}
\alias{rowVars,Zi-method}
\alias{colVars}
\alias{colVars,Zi-method}
\title{Row and Column Variances of zero inflated count data}
\usage{
\S4method{rowVars}{Zi}(x, rows = NULL, cols = NULL, na.rm = FALSE, useNames = TRUE)

\S4method{colVars}{Zi}(x, rows = NULL, cols = NULL, na.rm = FALSE, useNames = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{rows, cols}{A \code{\link[base]{vector}} indicating the subset of rows
and/or columns to operate over. If \code{\link{NULL}} (default), no subsetting
is done}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}}
\code{\link{NA}}s are excluded, otherwise not. default = \code{\link{FALSE}}}

\item{useNames}{\code{\link[base]{logical}}  If \code{\link{TRUE}} (default),
names attributes of result are set. Else if \code{\link{FALSE}}, no naming
support is done.}
}
\value{
a vector of row/col length
}
\description{
Calculate row and column variances of zero inflated count data
taking weights for structural zeros into account.
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
rowVars(Zi)
colVars(Zi)
}
