% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zinb_fit.R
\name{zinbFit}
\alias{zinbFit}
\alias{zinbFit,SummarizedExperiment-method}
\alias{zinbFit,matrix-method}
\alias{zinbFit,dgCMatrix-method}
\title{Fit a ZINB regression model}
\usage{
zinbFit(Y, ...)

\S4method{zinbFit}{SummarizedExperiment}(
  Y,
  X,
  V,
  K,
  which_assay,
  commondispersion = TRUE,
  zeroinflation = TRUE,
  verbose = FALSE,
  nb.repeat.initialize = 2,
  maxiter.optimize = 25,
  stop.epsilon.optimize = 1e-04,
  BPPARAM = BiocParallel::bpparam(),
  ...
)

\S4method{zinbFit}{matrix}(
  Y,
  X,
  V,
  K,
  commondispersion = TRUE,
  zeroinflation = TRUE,
  verbose = FALSE,
  nb.repeat.initialize = 2,
  maxiter.optimize = 25,
  stop.epsilon.optimize = 1e-04,
  BPPARAM = BiocParallel::bpparam(),
  ...
)

\S4method{zinbFit}{dgCMatrix}(Y, ...)
}
\arguments{
\item{Y}{The data (genes in rows, samples in columns).}

\item{...}{Additional parameters to describe the model, see
\code{\link{zinbModel}}.}

\item{X}{The design matrix containing sample-level covariates, one sample per
row. If missing, X will contain only an intercept. If Y is a
SummarizedExperiment object, X can be a formula using the variables in the
colData slot of Y.}

\item{V}{The design matrix containing gene-level covariates, one gene
per row. If missing, V will contain only an intercept. If Y is a
SummarizedExperiment object, V can be a formula using the variables in the
rowData slot of Y.}

\item{K}{integer. Number of latent factors.}

\item{which_assay}{numeric or character. Which assay of Y to use (only if Y
is a SummarizedExperiment).}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE).}

\item{zeroinflation}{Whether or not a ZINB model should be fitted. If FALSE,
a negative binomial model is fitted instead.}

\item{verbose}{Print helpful messages.}

\item{nb.repeat.initialize}{Number of iterations for the initialization of
beta_mu and gamma_mu.}

\item{maxiter.optimize}{maximum number of iterations for the optimization
step (default 25).}

\item{stop.epsilon.optimize}{stopping criterion in the optimization step,
when the relative gain in likelihood is below epsilon (default 0.0001).}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
An object of class \code{ZinbModel} that has been fitted by penalized
  maximum likelihood on the data.
}
\description{
Given an object with the data, it fits a ZINB model.
}
\details{
By default, i.e., if no arguments other than \code{Y} are passed,
  the model is fitted with an intercept for the regression across-samples and
  one intercept for the regression across genes, both for mu and for pi.

This means that by default the model is fitted with \code{X_mu =
  X_pi = 1_n} and \code{V_mu = V_pi = 1_J}. If the user explicitly passes the
  design matrices, this behavior is overwritten, i.e., the user needs to
  explicitly include the intercept in the design matrices.

If Y is a Summarized experiment, the function uses the assay named
  "counts", if any, or the first assay.

Currently, if Y is a sparseMatrix, this calls the zinbFit method on
  as.matrix(Y)
}
\section{Methods (by class)}{
\itemize{
\item \code{zinbFit(SummarizedExperiment)}: Y is a
\code{\link[SummarizedExperiment]{SummarizedExperiment}}.

\item \code{zinbFit(matrix)}: Y is a matrix of counts (genes in rows).

\item \code{zinbFit(dgCMatrix)}: Y is a sparse matrix of counts (genes in rows).

}}
\examples{
se <- SummarizedExperiment(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
                           colData = data.frame(bio = gl(2, 3)))

m <- zinbFit(se, X=model.matrix(~bio, data=colData(se)),
             BPPARAM=BiocParallel::SerialParam())
bio <- gl(2, 3)
m <- zinbFit(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
             X=model.matrix(~bio), BPPARAM=BiocParallel::SerialParam())
}
\seealso{
\code{\link[stats]{model.matrix}}.
}
