% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{zinbAIC}
\alias{zinbAIC}
\alias{zinbBIC}
\alias{zinbAIC,ZinbModel,matrix-method}
\alias{zinbBIC,ZinbModel,matrix-method}
\title{Compute the AIC or BIC of a model given some data}
\usage{
zinbAIC(model, x)

zinbBIC(model, x)

\S4method{zinbAIC}{ZinbModel,matrix}(model, x)

\S4method{zinbBIC}{ZinbModel,matrix}(model, x)
}
\arguments{
\item{model}{an object that describes a statistical model.}

\item{x}{an object that describes data.}
}
\value{
the AIC/BIC of the model.
}
\description{
Given a statistical model and some data, these functions compute the AIC or
BIC of the model given the data, i.e., the AIC/BIC of the data under the
model.
}
\section{Functions}{
\itemize{
\item \code{zinbAIC(model = ZinbModel, x = matrix)}: returns the AIC of the ZINB model.

\item \code{zinbBIC(model = ZinbModel, x = matrix)}: returns the BIC of the ZINB model.

}}
\examples{
se <- SummarizedExperiment(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
    colData = data.frame(bio = gl(2, 3)))
m <- zinbFit(se, X=model.matrix(~bio, data=colData(se)),
    BPPARAM=BiocParallel::SerialParam())
zinbAIC(m, t(assay(se)))
zinbBIC(m, t(assay(se)))
}
