% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthogonalizeTraceNorm.R
\name{orthogonalizeTraceNorm}
\alias{orthogonalizeTraceNorm}
\title{Orthogonalize matrices to minimize trace norm of their product}
\usage{
orthogonalizeTraceNorm(U, V, a = 1, b = 1)
}
\arguments{
\item{U}{left matrix}

\item{V}{right matrix}

\item{a}{weight of the norm of U (default=1)}

\item{b}{weight of the norm of V (default=1)}
}
\value{
A list with the two matrices that solve the problem in the slots U
  and V.
}
\description{
Given two matrices U and V that can be multiplied, this function finds two
new matrices U2 and V2 such that their product is conserved (U*V = U2*V2) and
such that a||U||^2 + b||V||^2 is minimized.
}
\examples{
U <- matrix(rnorm(15),5,3)
V <- matrix(rnorm(12),3,4)
o <- orthogonalizeTraceNorm(U,V)
norm( U\%*\%V - o$U\%*\%o$V) # should be zero
sum(U^2)+sum(V^2)
sum(o$U^2)+sum(o$V^2) # should be smaller
}
