% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_MSigDB.R
\name{get_MSigDB}
\alias{get_MSigDB}
\title{Load MSigDB genesets}
\usage{
get_MSigDB(
  cat,
  to = c("ENSEMBL", "SYMBOL", "ENTREZ"),
  organism = c("HS", "MM")
)
}
\arguments{
\item{cat}{array of categories to load.}

\item{to}{return genes names as \code{'ENSEMBL'} or \code{'SYMBOL'}}

\item{organism}{organism: human (\code{'HS'}) or mouse (\code{'MS'})}
}
\value{
Gene sets stored as GeneSetCollection
}
\description{
Load MSigDB genesets
}
\details{
This function loads the MSigDB gene sets using the packages  and \code{msigdbr}.  It can take a mintute to load because converting gene name type is slow.
}
\examples{
# load Hallmark gene sets
gs = get_MSigDB('H')

# load all gene sets
# gs = get_MSigDB()

}
