% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot heatmap of most variable genes}
\usage{
plotHeatmap(obj, n = NULL, fun = stats::sd, normalized = TRUE,
  log = TRUE, ...)
}
\arguments{
\item{obj}{ExpressionSet object or objrix.}

\item{n}{Number of features to make use of in plotting heatmap.}

\item{fun}{Function to sort genes by, default \code{\link[stats]{sd}}.}

\item{normalized}{TRUE / FALSE, use the normalized matrix or raw counts.}

\item{log}{TRUE/FALSE log2-transform raw counts.}

\item{...}{Additional plot arguments for \code{\link[gplots]{heatmap.2}}.}
}
\value{
coordinates
}
\description{
This function plots a heatmap of the gene expressions forthe "n" features of interest.
}
\examples{
data(skin)
tissues <- pData(skin)$SMTSD
plotHeatmap(skin,normalized=FALSE,log=TRUE,trace="none",n=10)
# Even prettier
\donttest{
# library(RColorBrewer)
data(skin)
tissues <- pData(skin)$SMTSD
heatmapColColors <- brewer.pal(12,"Set3")[as.integer(factor(tissues))]
heatmapCols <- colorRampPalette(brewer.pal(9, "RdBu"))(50)
plotHeatmap(skin,normalized=FALSE,log=TRUE,trace="none",n=10,
 col = heatmapCols,ColSideColors = heatmapColColors,cexRow = 0.6,cexCol = 0.6)
}
}
