% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_seg_g.R
\name{viewSegG2}
\alias{viewSegG2}
\title{naive polygon viewer, will indicate presence of transcripts for two genes in cells}
\usage{
viewSegG2(x, xlim, ylim, gene1, gene2, show_tx = FALSE, ...)
}
\arguments{
\item{x}{instance of XenSPEP}

\item{xlim}{numeric(2) ordered vector of max and min on x}

\item{ylim}{numeric(2) ordered vector of max and min on y}

\item{gene1}{character(1) gene to be checked, cell polygon will be filled if gene has non-zero count}

\item{gene2}{character(1) gene to be checked, cell polygon will be filled if gene has non-zero count}

\item{show_tx}{logical(1) display transcript locations if TRUE, defaults to FALSE.}

\item{\dots}{passed to polygon()}
}
\value{
Primarily for plotting.  A list is invisibly returned with elements polys,
ncells and call.
}
\description{
naive polygon viewer, will indicate presence of transcripts for two genes in cells
}
\note{
This is more RAM-sparing than clipRect followed by view.  Colors are
pre-assigned for individual and joint occupancies in this draft of this visualizer.
}
\examples{
luad <- cacheXenLuad()
pa <- cacheXenLuad()
luad <- restoreZipXenSPEP(pa)
rownames(luad) <- make.names(SummarizedExperiment:::rowData(luad)$Symbol, unique = TRUE)
out <- viewSegG2(luad, c(5800, 6300), c(1300, 1800), lwd = .5, gene1 = "CD4", gene2 = "EPCAM")
legend(5800, 1370, fill = c("purple", "cyan", "pink"), legend = c("CD4", "EPCAM", "both"))
out$ncells
}
