% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{translateCounts}
\alias{translateCounts}
\title{Translate counts matrix rownames}
\usage{
translateCounts(counts, dict)
}
\arguments{
\item{counts}{matrix of expression values.}

\item{dict}{named character vector mapping \code{counts} rownames to new
values. Values of vector should correspond to new desired rownames, and its
names to current rownames.}
}
\value{
matrix of expression values with new rownames.
}
\description{
\code{translateCounts} renames counts matrix rownames according to supplied
\code{dict}ionary. Function can handle many to one assignments by taking a
sum or an average over \code{counts} rows. Other types of ambiguous
assignments are not supported.
}
\examples{
counts <- matrix(
data = c(5, 4, 3, 2),
nrow = 2,
   dimnames = list(
     c("ENSG00000130700", "ENSG00000089225"),
     c("treatment", "control")
   )
 )
dict <- c(ENSG00000130700 = "GATA5", ENSG00000089225 = "TBX5")
translateCounts(counts, dict)

}
