% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ridgePvals}
\alias{ridgePvals}
\title{Significance testing in linear ridge regression}
\usage{
ridgePvals(x, y, beta, lambda, standardizex = TRUE, svdX = NULL)
}
\arguments{
\item{x}{input matrix, same as used in \code{\link[glmnet]{cv.glmnet}}.}

\item{y}{response variable, same as used in \code{\link[glmnet]{cv.glmnet}}.}

\item{beta}{matrix of coefficients, estimated using
\code{\link[glmnet]{cv.glmnet}}.}

\item{lambda}{lambda value for which \code{beta} was estimated.}

\item{standardizex}{logical flag for x variable standardization, should be
set to same value as \code{standarize} flag in \code{\link[glmnet]{cv.glmnet}}.}

\item{svdX}{optional singular-value decomposition of \code{x} matrix. One can
be obtained using \code{link[base]{svd}}. Passing this argument omits
internal call to \code{link[base]{svd}}, this is useful when calling
\code{ridgePvals} repeatedly using same \code{x}.}
}
\value{
a data.frame with columns
\describe{
\item{coef}{\code{beta}'s names}
\item{se}{\code{beta}'s standard errors}
\item{tstat}{\code{beta}'s test statistic}
\item{pval}{\code{beta}'s p-values}
}
}
\description{
Standard error estimation and significance testing for coefficients
estimated in linear ridge regression. \code{ridgePvals} re-implement
original method by (Cule et al. BMC Bioinformatics 2011.) found in
\link[ridge]{ridge-package}. This function is intended to use with
\code{\link[glmnet]{cv.glmnet}} output.
}
