% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{regressionData}
\alias{regressionData}
\title{Create MultiAssayExperiment object for expression modeling}
\usage{
regressionData(expr_mat, design, base_lvl, drop_base_lvl = TRUE)
}
\arguments{
\item{expr_mat}{matrix of expression values.}

\item{design}{matrix giving the design matrix for the samples. Columns
corresponds to samples groups and rows to samples names.}

\item{base_lvl}{string indicating group in \code{design} corresponding to
basal expression level. The reference samples to which expression change
will be compared.}

\item{drop_base_lvl}{logical flag indicating if \code{base_lvl} samples
should be dropped from resulting MultiAssayExperiment object.}
}
\value{
MultiAssayExperiment object with two experiments:
\describe{
\item{U}{matrix giving expression values averaged over basal level samples}
\item{Y}{matrix of expression values}
}
design with \code{base_lvl} dropped is stored in metadata and directly
available for \code{modelGeneExpression}.
}
\description{
\code{regressionData} orgnize expression data and experiment design into
MultiAssayExperiment object that can be further used in \code{xcore}
framework. Additionally, function calculate basal expression level, for
latter use in expression modeling, by averaging \code{base_lvl} samples
expression values.
}
\details{
Note that \code{regressionData} does not apply any normalization or
transformation to the input data! Use \code{prepareCountsForRegression}
if you want to start with raw expression counts.
}
\examples{
data("rinderpest_mini")
base_lvl <- "00hr"
design <- matrix(
  data = c(1, 0, 0,
           1, 0, 0,
           1, 0, 0,
           0, 1, 0,
           0, 1, 0,
           0, 1, 0,
           0, 0, 1,
           0, 0, 1,
           0, 0, 1),
  ncol = 3,
  nrow = 9,
  byrow = TRUE,
  dimnames = list(colnames(rinderpest_mini), c("00hr", "12hr", "24hr")))
mae <- regressionData(
  expr_mat = rinderpest_mini,
  design = design,
  base_lvl = base_lvl)

}
