% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{applyOverDFList}
\alias{applyOverDFList}
\title{Apply function over selected column in list of data frames}
\usage{
applyOverDFList(list_of_df, col_name, fun, groups)
}
\arguments{
\item{list_of_df}{list of \code{data.frame}s.}

\item{col_name}{string specifying column in \code{data.frame}s to apply
\code{fun} on.}

\item{fun}{function to apply, should take a single vector as a argument.}

\item{groups}{factor defining how elements of \code{list_of_df} should be
grouped.}
}
\value{
matrix with \code{nrow(list_of_df[[1]])} rows and
\code{nlevels(groups)} columns.
}
\description{
\code{applyOverDFList} operates on a list of data frames where all data frames
has the same size and columns. Column of interest is extracted from each data
frame and column binded in \code{groups}, next \code{fun} is applied over
rows. Final result is a matrix with result for each group on a separate column.
Function is parallelized over groups.
}
