% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-XCMSnExp.R
\name{overlappingFeatures}
\alias{overlappingFeatures}
\title{Identify overlapping features}
\usage{
overlappingFeatures(x, expandMz = 0, expandRt = 0, ppm = 0)
}
\arguments{
\item{x}{\code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}} object with the features.}

\item{expandMz}{\code{numeric(1)} with the value to expand each feature (on each
side) in m/z dimension before identifying overlapping features.
The resulting \code{"mzmin"} for the feature is thus \code{mzmin - expandMz} and
the \code{"mzmax"} \code{mzmax + expandMz}.}

\item{expandRt}{\code{numeric(1)} with the value to expand each feature (on each
side) in retention time dimension before identifying overlapping
features. The resulting \code{"rtmin"} for the
feature is thus \code{rtmin - expandRt} and the \code{"rtmax"} \code{rtmax + expandRt}.}

\item{ppm}{\code{numeric(1)} to grow the m/z width of the feature by a relative
value: \code{mzmin - mzmin * ppm / 2e6}, \code{mzmax + mzmax * ppm / 2e6}. Each
feature is thus expanded in m/z dimension by ppm/2 on each side before
identifying overlapping features.}
}
\value{
\code{list} with indices of features (in \code{\link[=featureDefinitions]{featureDefinitions()}}) that
are overlapping.
}
\description{
\code{overlappingFeatures} identifies features that are overlapping or close in
the m/z - rt space.
}
\examples{

## Load a test data set with detected peaks
library(MSnbase)
data(faahko_sub)
## Update the path to the files for the local system
dirname(faahko_sub) <- system.file("cdf/KO", package = "faahKO")

## Disable parallel processing for this example
register(SerialParam())

## Correspondence analysis
xdata <- groupChromPeaks(faahko_sub, param = PeakDensityParam(sampleGroups = c(1, 1, 1)))

## Identify overlapping features
overlappingFeatures(xdata)

## Identify features that are separated on retention time by less than
## 2 minutes
overlappingFeatures(xdata, expandRt = 60)
}
\author{
Johannes Rainer
}
