% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/methods-XCMSnExp.R
\name{manualChromPeaks}
\alias{manualChromPeaks}
\alias{manualFeatures}
\alias{manualChromPeaks,MsExperiment-method}
\alias{manualChromPeaks,XcmsExperiment-method}
\alias{manualFeatures,XcmsExperiment-method}
\alias{manualChromPeaks,OnDiskMSnExp-method}
\alias{manualChromPeaks,XCMSnExp-method}
\alias{manualFeatures,XCMSnExp-method}
\title{Manual peak integration and feature definition}
\usage{
manualChromPeaks(object, ...)

manualFeatures(object, ...)

\S4method{manualChromPeaks}{MsExperiment}(
  object,
  chromPeaks = matrix(numeric()),
  samples = seq_along(object),
  msLevel = 1L,
  chunkSize = 2L,
  BPPARAM = bpparam()
)

\S4method{manualChromPeaks}{XcmsExperiment}(
  object,
  chromPeaks = matrix(numeric()),
  samples = seq_along(object),
  msLevel = 1L,
  chunkSize = 2L,
  BPPARAM = bpparam()
)

\S4method{manualFeatures}{XcmsExperiment}(object, peakIdx = list(), msLevel = 1L)

\S4method{manualChromPeaks}{OnDiskMSnExp}(
  object,
  chromPeaks = matrix(),
  samples = seq_along(fileNames(object)),
  msLevel = 1L,
  BPPARAM = bpparam()
)

\S4method{manualChromPeaks}{XCMSnExp}(
  object,
  chromPeaks = matrix(),
  samples = seq_along(fileNames(object)),
  msLevel = 1L,
  BPPARAM = bpparam()
)

\S4method{manualFeatures}{XCMSnExp}(object, peakIdx = list(), msLevel = 1L)
}
\arguments{
\item{object}{\link{XcmsExperiment}, \link{XCMSnExp} or \link[MSnbase:OnDiskMSnExp-class]{MSnbase::OnDiskMSnExp} object.}

\item{...}{ignored.}

\item{chromPeaks}{For \code{manualChromPeaks}: \code{matrix} defining the boundaries
of the chromatographic peaks with one row per chromatographic peak and
columns \code{"mzmin"}, \code{"mzmax"}, \code{"rtmin"} and \code{"rtmax"} defining the
m/z and retention time region of each peak.}

\item{samples}{For \code{manualChromPeaks}: optional \code{integer} defining
individual samples in which the peak integration should be performed.
Defaults to all samples.}

\item{msLevel}{\code{integer(1)} defining the MS level in which peak integration
should be performed. Only a single MS level at a time is supported.
Defaults to \code{msLevel = 1L}.}

\item{chunkSize}{\code{integer(1)} defining the number of files (samples)
that should be loaded into memory and processed at the same time.
Peak integration is then performed in parallel (per sample) on this
subset data. This setting thus allows to balance between memory
demand and speed (due to parallel processing). Because parallel
processing can only performed on the subset of data currently loaded
into memory in each iteration, the value for \code{chunkSize} should match
the defined  parallel setting setup. Using a parallel processing setup
using 4 CPUs (separate processes) but using \verb{chunkSize = }1\verb{will not perform any parallel processing, as only the data from one sample is loaded in memory at a time. On the other hand, setting}chunkSize` to
the total number of samples in an experiment will load the full MS data
into memory and will thus in most settings cause an out-of-memory error.}

\item{BPPARAM}{parallel processing settings (see \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for details).}

\item{peakIdx}{For \code{manualFeatures}: \code{list} of \code{integer} vectors with the
indices of chromatographic peaks in the object's \code{chromPeaks} matrix
that should be grouped into features.}
}
\value{
\code{XcmsExperiment} or \code{XCMSnExp} with the manually added
chromatographic peaks or features.
}
\description{
The \code{manualChromPeaks} function allows to \emph{manually} define chromatographic
peaks, integrate the intensities within the specified peak area and add
them to the object's \code{chromPeaks} matrix. A peak is not added for a sample
if no signal was found in the respective data file.

Because chromatographic peaks are added to eventually previously identified
peaks, it is suggested to run \code{\link[=refineChromPeaks]{refineChromPeaks()}} with the
\code{\link[=MergeNeighboringPeaksParam]{MergeNeighboringPeaksParam()}} approach to merge potentially overlapping
peaks.

The \code{manualFeatures} function allows to manually group identified
chromatographic peaks into features by providing their index in the
object's \code{chromPeaks} matrix.
}
\examples{

## Read a test dataset.
fls <- c(system.file("microtofq/MM14.mzML", package = "msdata"),
         system.file("microtofq/MM8.mzML", package = "msdata"))

## Define a data frame with some sample annotations
ann <- data.frame(
    injection_index = 1:2,
    sample_id = c("MM14", "MM8"))

## Import the data
library(MsExperiment)
mse <- readMsExperiment(fls)

## Define some arbitrary peak areas
pks <- cbind(
    mzmin = c(512, 234.3), mzmax = c(513, 235),
    rtmin = c(10, 33), rtmax = c(19, 50)
)
pks

res <- manualChromPeaks(mse, pks)
chromPeaks(res)

## Peaks were only found in the second file.
}
\author{
Johannes Rainer
}
