% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-XCMSnExp.R
\name{[,XCMSnExp,ANY,ANY,ANY-method}
\alias{[,XCMSnExp,ANY,ANY,ANY-method}
\alias{XCMSnExp-filter}
\alias{[[,XCMSnExp,ANY,ANY-method}
\alias{filterMsLevel,XCMSnExp-method}
\alias{filterFile,XCMSnExp-method}
\alias{filterMz,XCMSnExp-method}
\alias{filterRt,XCMSnExp-method}
\alias{split,XCMSnExp,ANY-method}
\alias{filterChromPeaks,XCMSnExp-method}
\alias{filterFeatureDefinitions,XCMSnExp-method}
\title{XCMSnExp filtering and subsetting}
\usage{
\S4method{[}{XCMSnExp,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{XCMSnExp,ANY,ANY}(x, i, j, drop = FALSE)

\S4method{filterMsLevel}{XCMSnExp}(object, msLevel., keepAdjustedRtime = hasAdjustedRtime(object))

\S4method{filterFile}{XCMSnExp}(
  object,
  file,
  keepAdjustedRtime = hasAdjustedRtime(object),
  keepFeatures = FALSE
)

\S4method{filterMz}{XCMSnExp}(object, mz, msLevel., ...)

\S4method{filterRt}{XCMSnExp}(object, rt, msLevel., adjusted = hasAdjustedRtime(object))

\S4method{split}{XCMSnExp,ANY}(x, f, drop = FALSE, ...)

\S4method{filterChromPeaks}{XCMSnExp}(
  object,
  keep = rep(TRUE, nrow(chromPeaks(object))),
  method = "keep",
  ...
)

\S4method{filterFeatureDefinitions}{XCMSnExp}(object, features = integer())
}
\arguments{
\item{x}{For \code{[} and \code{[[}: an \code{XCMSnExp} object.}

\item{i}{For \code{[}: \code{numeric} or \code{logical} vector specifying to
which spectra the data set should be reduced.
For \code{[[}: a single integer or character.}

\item{j}{For \code{[} and \code{[[}: not supported.}

\item{...}{Optional additional arguments.}

\item{drop}{For \code{[} and \code{[[}: not supported.}

\item{object}{A \link{XCMSnExp} object.}

\item{msLevel.}{For \code{filterMz}, \code{filterRt}: \code{numeric}
defining the MS level(s) to which operations should be applied or to
which the object should be subsetted.}

\item{keepAdjustedRtime}{For \code{filterFile}, \code{filterMsLevel},
\code{[}, \code{split}: \code{logical(1)} defining whether the adjusted
retention times should be kept, even if e.g. features are being removed
(and the retention time correction was performed on these features).}

\item{file}{For \code{filterFile}: \code{integer} defining the file index
within the object to subset the object by file or \code{character}
specifying the file names to sub set. The indices are expected to be
increasingly ordered, if not they are ordered internally.}

\item{keepFeatures}{For \code{filterFile}: \code{logical(1)} whether
correspondence results (feature definitions) should be kept or dropped.
Defaults to \code{keepFeatures = FALSE} hence feature definitions are removed
from the returned object by default.}

\item{mz}{For \code{filterMz}: \code{numeric(2)} defining the lower and upper
mz value for the filtering.}

\item{rt}{For \code{filterRt}: \code{numeric(2)} defining the retention time
window (lower and upper bound) for the filtering.}

\item{adjusted}{For \code{filterRt}: \code{logical} indicating whether the
object should be filtered by original (\code{adjusted = FALSE}) or
adjusted retention times (\code{adjusted = TRUE}).
For \code{spectra}: whether the retention times in the individual
\code{Spectrum} objects should be the adjusted or raw retention times.}

\item{f}{For \code{split} a vector of length equal to the length of x
defining how \code{x} should be splitted. It is converted internally to
a \code{factor}.}

\item{keep}{For \code{filterChromPeaks}: \code{logical}, \code{integer} or \code{character}
defining which chromatographic peaks should be retained.}

\item{method}{For \code{filterChromPeaks}: \code{character(1)} allowing to specify the
method by which chromatographic peaks should be filtered. Currently only
\code{method = "keep"} is supported (i.e. specify with parameter \code{keep} which
chromatographic peaks should be retained).}

\item{features}{For \code{filterFeatureDefinitions}: either a \code{integer}
specifying the indices of the features (rows) to keep, a \code{logical}
with a length matching the number of rows of \code{featureDefinitions}
or a \code{character} with the feature (row) names.}
}
\value{
All methods return an \link{XCMSnExp} object.
}
\description{
The methods listed on this page allow to filter and subset \link{XCMSnExp}
objects. Most of them are inherited from the \link[MSnbase:OnDiskMSnExp-class]{MSnbase::OnDiskMSnExp} object
defined in the \emph{MSnbase} package and have been adapted for \code{XCMSnExp} to
enable correct subsetting of preprocessing results.
\itemize{
\item \code{[}: subset a \code{XCMSnExp} object by spectra. Be aware that this removes
\strong{all} preprocessing results, except adjusted retention times if
\code{keepAdjustedRtime = TRUE} is passed to the method.
\item \code{[[}: extracts a single \code{Spectrum} object (defined in \code{MSnbase}). The
reported retention time is the adjusted retention time if alignment has
been performed.
\item \code{filterChromPeaks}: subset the \code{chromPeaks} \code{matrix} in \code{object}. Parameter
\code{method} allows to specify how the chromatographic peaks should be
filtered. Currently, only \code{method = "keep"} is supported which allows to
specify chromatographic peaks to keep with parameter \code{keep} (i.e. provide
a \code{logical}, \code{integer} or \code{character} defining which chromatographic peaks
to keep). Feature definitions (if present) are updated correspondingly.
\item \code{filterFeatureDefinitions}: allows to subset the feature definitions of
an \code{XCMSnExp} object. Parameter \code{features} allow to define which features
to keep. It can be a \code{logical}, \code{integer} (index of features to keep) or
\code{character} (feature IDs) vector.
\item \code{filterFile}: allows to reduce the \code{XCMSnExp} to data from only selected
files. Identified chromatographic peaks for these files are retained while
correspondence results (feature definitions) are removed by default. To
force keeping feature definitions use \code{keepFeatures = TRUE}. Adjusted
retention times (if present) are retained by default if present. Use
\code{keepAdjustedRtime = FALSE} to drop them.
\item \code{filterMsLevel}: reduces the \code{XCMSnExp} object to spectra of the
specified MS level(s). Chromatographic peaks and identified features are
also subsetted to the respective MS level. See also the \code{filterMsLevel}
documentation in \code{MSnbase} for details and examples.
\item \code{filterMz}: filters the data set based on the provided m/z value range.
All chromatographic peaks and features (grouped peaks) with their apex
falling within the provided mz value range are retained
(i.e. if \code{chromPeaks(object)[, "mz"]} is \verb{>= mz[1]} and \verb{<= mz[2]}).
Adjusted retention times, if present, are kept.
\item \code{filterRt}: filters the data set based on the provided retention time
range. All chromatographic peaks and features (grouped peaks)
within the specified retention time window are retained
(i.e. if the retention time corresponding to the peak's apex is within the
specified rt range). If retention time correction has been performed,
the method will by default filter the object by adjusted retention times.
The argument \code{adjusted} allows to specify manually whether filtering
should be performed on raw or adjusted retention times. Filtering by
retention time does not drop any preprocessing results nor does it remove
or change alignment results (i.e. adjusted retention times).
The method returns an empty object if no spectrum or feature is within
the specified retention time range.
\item \code{split}: splits an \code{XCMSnExp} object into a \code{list} of \code{XCMSnExp} objects
based on the provided parameter \code{f}. Note that by default all
pre-processing results are removed by the splitting, except adjusted
retention times, if the optional argument \code{keepAdjustedRtime = TRUE} is
provided.
}
}
\details{
All subsetting methods try to ensure that the returned data is
consistent. Correspondence results for example are removed by default if the
data set is sub-setted by file, since the correspondence results are
dependent on the files on which correspondence was performed. This can be
changed by setting \code{keepFeatures = TRUE}.
For adjusted retention times, most subsetting methods
support the argument \code{keepAdjustedRtime} (even the \code{[} method)
that forces the adjusted retention times to be retained even if the
default would be to drop them.
}
\note{
The \code{filterFile} method removes also process history steps not
related to the files to which the object should be sub-setted and updates
the \code{fileIndex} attribute accordingly. Also, the method does not
allow arbitrary ordering of the files or re-ordering of the files within
the object.

Note also that most of the filtering methods, and also the subsetting
operations \code{[} drop all or selected preprocessing results. To
consolidate the alignment results, i.e. ensure that adjusted retention
times are always preserved, use the \code{\link[=applyAdjustedRtime]{applyAdjustedRtime()}}
function on the object that contains the alignment results. This replaces
the raw retention times with the adjusted ones.
}
\examples{

## Loading a test data set with identified chromatographic peaks
library(MSnbase)
data(faahko_sub)
## Update the path to the files for the local system
dirname(faahko_sub) <- system.file("cdf/KO", package = "faahKO")

## Disable parallel processing for this example
register(SerialParam())

## Subset the dataset to the first and third file.
xod_sub <- filterFile(faahko_sub, file = c(1, 3))

## The number of chromatographic peaks per file for the full object
table(chromPeaks(faahko_sub)[, "sample"])

## The number of chromatographic peaks per file for the subset
table(chromPeaks(xod_sub)[, "sample"])

basename(fileNames(faahko_sub))
basename(fileNames(xod_sub))

## Filter on mz values; chromatographic peaks and features within the
## mz range are retained (as well as adjusted retention times).
xod_sub <- filterMz(faahko_sub, mz = c(300, 400))
head(chromPeaks(xod_sub))
nrow(chromPeaks(xod_sub))
nrow(chromPeaks(faahko_sub))

## Filter on rt values. All chromatographic peaks and features within the
## retention time range are retained. Filtering is performed by default on
## adjusted retention times, if present.
xod_sub <- filterRt(faahko_sub, rt = c(2700, 2900))

range(rtime(xod_sub))
head(chromPeaks(xod_sub))
range(chromPeaks(xod_sub)[, "rt"])

nrow(chromPeaks(faahko_sub))
nrow(chromPeaks(xod_sub))

## Extract a single Spectrum
faahko_sub[[4]]

## Subsetting using [ removes all preprocessing results - using
## keepAdjustedRtime = TRUE would keep adjusted retention times, if present.
xod_sub <- faahko_sub[fromFile(faahko_sub) == 1]
xod_sub

## Using split does also remove preprocessing results, but it supports the
## optional parameter keepAdjustedRtime.
## Split the object into a list of XCMSnExp objects, one per file
xod_list <- split(faahko_sub, f = fromFile(faahko_sub))
xod_list
}
\seealso{
\link{XCMSnExp} for base class documentation.

\code{\link[=XChromatograms]{XChromatograms()}} for similar filter functions on
\code{XChromatograms} objects.
}
\author{
Johannes Rainer
}
