% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_imports.R
\name{convertSE}
\alias{convertSE}
\title{Convert the phenotype data of a SummarizedExperiment into a dataframe for WPM}
\usage{
convertSE(se_object, gp_field = NULL)
}
\arguments{
\item{se_object}{a SummarizedExperiment object containing the phenotype data}

\item{gp_field}{character, corresponding to the phenotype data used to
categorize samples into distinct groups if any}
}
\value{
a dataframe containing 3 fields: Sample, Group and ID.
}
\description{
Convert the phenotype data of a SummarizedExperiment into a dataframe for WPM
}
\examples{
nrows <- 200
ncols <- 6
counts <- matrix(runif(nrows * ncols, 1, 1e4), nrows)
colData <- data.frame(Treatment=rep(c("ChIP", "Input"), 3),
                    row.names=LETTERS[1:6])
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=counts), colData=colData)
convertSE(se, "Treatment")
}
