% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenienceWrappers.R
\name{plotTranscriptsFromEnsembldb}
\alias{plotTranscriptsFromEnsembldb}
\title{Plot transcripts directly from ensembldb object.}
\usage{
plotTranscriptsFromEnsembldb(ensembldb, gene_names, transcript_ids = NULL, ...)
}
\arguments{
\item{ensembldb}{ensembldb object.}

\item{gene_names}{List of gene names to be plotted.}

\item{transcript_ids}{Optional list of transcript ids to be plotted.}

\item{...}{Additional parameters to be passed to plotTranscripts}
}
\value{
ggplot2 object
}
\description{
A wrapper around the plotTranscripts function. See the documentation for (\code{\link[wiggleplotr]{plotTranscripts}}) 
for more information.
}
\examples{
require("EnsDb.Hsapiens.v86")
plotTranscriptsFromEnsembldb(EnsDb.Hsapiens.v86, "NCOA7", transcript_ids = c("ENST00000438495", "ENST00000392477"))
}
