% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_count.R
\name{weitrix_hill}
\alias{weitrix_hill}
\title{Calculate Hill numbers (effective number of observations) for rows or columns}
\usage{
weitrix_hill(weitrix, what = c("row", "col"), order = 2)
}
\arguments{
\item{weitrix}{A weitrix object.}

\item{what}{Calculate for rows ("row") (default) or columns ("col")?}

\item{order}{Order of the Hill numbers.}
}
\value{
A numeric vector of effective numbers of observations.
}
\description{
Effective numbers of observations. 
\code{order=0} produces count of non-zero weights. 
\code{order=1} produces exp(entropy). 
\code{order=2} produces the inverse Simpson index.
}
\examples{
weitrix_weights(simwei)

weitrix_hill(simwei, what="row", order=0)
weitrix_hill(simwei, what="row", order=1)
weitrix_hill(simwei, what="row", order=2)

weitrix_hill(simwei, what="col", order=0)
weitrix_hill(simwei, what="col", order=1)
weitrix_hill(simwei, what="col", order=2)

}
