% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMeta.R
\name{getMetaTSS}
\alias{getMetaTSS}
\title{Compute and plot read densities in genomic regions around transcription
start sites}
\usage{
getMetaTSS(sortedBam, txDB = NULL, upstream = 1e3, downstream = 1e3,
nBins = 40, genome = 'hg19', tablename = 'ensGene', unique = FALSE, plot =
TRUE, verbose = TRUE, ...)
}
\arguments{
\item{sortedBam}{GRanges object containing aligned reads as returned by
\link{readSortedBam}}

\item{txDB}{TranscriptDb object obtained through a call to the
\code{makeTxDbFromUCSC} function in the \code{GenomicFeatures}
package. Default is NULL, namely the object will be fetched internally}

\item{upstream}{An integer corresponding to the number of bases to be
considered upstream the TSS. Default is 1000}

\item{downstream}{An integer corresponding to the number of bases to be
considered downstream the TSS. Default is 1000}

\item{nBins}{An integer corresponding to the number of bins to be used to
partition the genes. Default is 40, i.e. bin size 50 bases}

\item{genome}{A character specifying the genome abbreviation used by UCSC.
Available abbreviations are returned by a call to \code{ucscGenomes()[ ,
"db"]}. Default is "hg19" (human genome)}

\item{tablename}{A character specifying the name of the UCSC table
containing the transcript annotations to retrieve. Available table names are
returned by a call to \code{supportedUCSCtables()}. Default is "ensGene",
namely ensembl gene annotations}

\item{unique}{Logical, if TRUE only non-overlapping TSSs extended by
upstream/downstream are considered. Default is FALSE, i.e. all TSSs are
considered}

\item{plot}{Logical, if TRUE a dotchart with cluster annotations is produced}

\item{verbose}{Logical, if TRUE processing steps are printed}

\item{...}{Additional parameters to be passed to the \code{plot} function}
}
\value{
A numeric vector of the same length as \code{nBins} containing
normalized counts. If \code{plot}, the metaTSS profile is also depicted as a
line plot.
}
\description{
Aligned reads are used generate a metaTSS profile across genomic regions
containing transcription start sites (TSSs).
}
\examples{

require(BSgenome.Hsapiens.UCSC.hg19)

filename <- system.file( "extdata", "example.bam", package = "wavClusteR" )
example <- readSortedBam( filename = filename )
\dontrun{tss <- getMetaTSS( sortedBam = example )}

}
\references{
Comoglio F*, Sievers C* and Paro R, wavClusteR: an R package for
PAR-CLIP data analysis, submitted
}
\seealso{
\code{\link{readSortedBam}}
}
\author{
Federico Comoglio
}
\keyword{graphics}
\keyword{postprocessing}
