% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WassersteinSingleCell.R
\name{.testWass}
\alias{.testWass}
\title{Check for differential distributions in single-cell RNA sequencing data via a semi-paramteric test using the 2-Wasserstein distance}
\usage{
.testWass(dat, condition, permnum, inclZero = TRUE, seed = NULL)
}
\arguments{
\item{dat}{matrix of single-cell RNA-sequencing expression data, with rowas corresponding to genes and columns corresponding to cells (samples)}

\item{condition}{vector of condition labels}

\item{permnum}{number of permutations used in the permutation testing
procedure}

\item{inclZero}{logical; if TRUE, a one-stage method is performed, i.e. the semi-parametric
test based on the 2-Wasserstein distance is applied to all (zero and non-zero) expression values;
if FALSE, a two-stage method is performed, i.e. the semi-parametric test based on the 2-Wasserstein distance is applied to
non-zero expression values only, and a separate test for
differential proportions of zero expression using logistic regression is conducted; default is TRUE}

\item{seed}{Number to be used as a L'Ecuyer-CMRG seed, which itself
seeds the generation of an nextRNGStream() for each gene. Internally, when
this argument is given, a seed is specified by calling
`RNGkind("L'Ecuyer-CMRG")` followed by `set.seed(seed)`.
The `RNGkind` and `.Random.seed` will be reset on termination of this
function. Default is NULL, and no seed is set.}
}
\value{
Matrix, where each row contains the testing results of the respective gene from \code{dat}.
 For the corresponding values of each row (gene), see the description of the function
\code{wasserstein.sc}, where the argument \code{inclZero=TRUE} in \code{.testWass} has to be
identified with the argument \code{method="OS"}, and the argument \code{inclZero=FALSE} with the argument \code{method="TS"}.
}
\description{
Two-sample test for single-cell RNA-sequencing data to check for differences
between two distributions using the 2-Wasserstein distance:
Semi-parametric implementation using a permutation test with a generalized 
Pareto distribution (GPD) approximation to estimate small p-values accurately
}
\details{
Details concerning the testing procedure for
single-cell RNA-sequencing data can be found in Schefzik et al. (2021) and in the description of the details of the function \code{wasserstein.sc}.
}
\references{
Schefzik, R., Flesch, J., and Goncalves, A. (2021). Fast identification of differential distributions in single-cell RNA-sequencing data with waddR.
}
