% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulcan.R
\name{vulcan.annotate}
\alias{vulcan.annotate}
\title{Function to annotate peaks for VULCAN analysis}
\usage{
vulcan.annotate(
  vobj,
  lborder = -10000,
  rborder = 10000,
  method = c("closest", "strongest", "sum", "topvar", "farthest", "lowvar"),
  TxDb = NULL
)
}
\arguments{
\item{vobj}{A list of peakcounts, samples and peakrpkms (i.e. the output of
the function vulcan.import)}

\item{lborder}{Boundary for peak annotation (in nucleotides) upstream of
the Transcription starting site (default: -10000)}

\item{rborder}{Boundary for peak annotation (in nucleotides) downstream of
the Transcription starting site (default: 10000)}

\item{method}{Method to deal with multiple peaks found within gene promoter
boundaries. One of sum (default), closest, strongest, topvar, farthest or
lowvar. This will affect only genes with multiple possible peaks. When a
single peak can be mapped to the promoter region of the gene, that peak
abundance will be considered as the gene promoter's occupancy.
\describe{
\item{sum}{when multiple peaks are found, sum their contributions}
\item{closest}{when multiple peaks are found, keep only the closest to the
TSS as the representative one}
\item{strongest}{when multiple peaks are found, keep the strongest as the
representative one}
\item{farthest}{when multiple peaks are found, keep only the closest to the
TSS as the representative one}
\item{topvar}{when multiple peaks are found, keep the most varying as the
representative one}
\item{lowvar}{when multiple peaks are found, keep the least varying as the
representative one}
}}

\item{TxDb}{TxDb annotation object containing the knownGene track. If NULL
(the default), TxDb.Hsapiens.UCSC.hg19.knownGene is loaded}
}
\value{
A list of components:
\describe{
\item{peakcounts}{A matrix of raw peak counts, peaks as rows, samples as
columns}
\item{peakrpkms}{A matrix of peak RPKMs, peaks as rows, samples as
columns}
\item{rawcounts}{A matrix of raw gene counts, genes as rows, samples as
columns. The counts are associated to the promoter region of the gene}
\item{rpkms}{A matrix of RPKMs, genes as rows, samples as
columns. The RPKMs are associated to the promoter region of the gene}
\item{samples}{A vector of sample names and conditions}
}
}
\description{
This function coalesces and annotates a set of BAM files into peak-centered
data. It implements the ChIPPeakANno methods, with specific choices dealing
with defining the genomic area around the promoter and which peaks to
include.
}
\examples{
library(vulcandata)
vobj<-vulcandata::vulcanexample()
vobj<-vulcan.annotate(vobj,lborder=-10000,rborder=10000,method='sum')
}
