% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulcan.R
\name{vulcan}
\alias{vulcan}
\title{VULCAN - VirtUaL Chipseq data Analysis using Networks}
\usage{
vulcan(vobj, network, contrast, annotation = NULL, minsize = 10)
}
\arguments{
\item{vobj}{a list, the output of the \code{'vulcan.normalize'} function}

\item{network}{an object of class \code{'viper::regulon'}}

\item{contrast}{a vector of two fields, containing the condition names
to be compared (1 vs 2)}

\item{annotation}{an optional named vector to convert gene identifiers
(e.g. entrez ids to gene symbols)
Default (NULL) won't convert gene names.}

\item{minsize}{integer indicating the minimum regulon size for the analysis
to be run. Default: 10}
}
\value{
A list of components:
\describe{
\item{peakcounts}{A matrix of raw peak counts, peaks as rows, samples as
columns}
\item{peakrpkms}{A matrix of peak RPKMs, peaks as rows, samples as
columns}
\item{rawcounts}{A matrix of raw gene counts, genes as rows, samples as
columns. The counts are associated to the promoter region of the gene}
\item{rpkms}{A matrix of RPKMs, genes as rows, samples as
columns. The RPKMs are associated to the promoter region of the gene}
\item{normalized}{A matrix of gene abundances normalized by
Variance-Stabilizing Transformation (VST), genes as rows, samples as
columns. The abundances are associated to the promoter
region of the gene}
\item{samples}{A vector of sample names and conditions}
\item{msviper}{a multisample virtual proteomics object from the
viper package}
\item{mrs}{A table of master regulators for a specific signature, indicating
their Normalized Enrichment Score (NES) and p-value}
}
}
\description{
This function calculates the enrichment of a gene regulatory network over a
ChIP-Seq derived signature
}
\examples{
library(vulcandata)
# Get an example vulcan object (generated with vulcan.import() using the
# dummy dataset contained in the \textit{vulcandata} package)
vobj<-vulcandata::vulcanexample()
# Annotate peaks to gene names
vobj<-vulcan.annotate(vobj,lborder=-10000,rborder=10000,method='sum')
# Normalize data for VULCAN analysis
vobj<-vulcan.normalize(vobj)
# Detect which conditions are present
names(vobj$samples)

# Load an ARACNe network
# This is a regulon object as specified in the VIPER package, named 'network'
load(system.file('extdata','network.rda',package='vulcandata',mustWork=TRUE))
# Run VULCAN
# We can reduce the minimum regulon size, since in this example only one
# chromosome
# was measured, and the networks would otherwise have too few hits
vobj_analysis<-vulcan(vobj,network=network,contrast=c('t90','t0'),minsize=5)
# Visualize output using the msviper plotting function
plot(vobj_analysis$msviper,mrs=7)

}
