% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpEstimate.R
\name{tpEstimate}
\alias{tpEstimate}
\title{Estimate transition probilities conditioning on CpG-CpG distance}
\usage{
tpEstimate(
  list,
  max_dist_bp = 2000,
  buffer_bp = 3000,
  lags = 1:10,
  BPPARAM = bpparam(),
  degree = 2,
  span = 0.02,
  ...
)
}
\arguments{
\item{list}{a list of data.frame objects. Each data.frame
contains information of 1 unit of training data (can be a cell or a
subtype) and should have 3 columns in strict rder of: (chr), (pos),
(binary methyl value). Column names are not necessary.}

\item{max_dist_bp}{positive integer value indicating the maximum
CpG-CpG distance in base pairs before the transition probabilities
reach constant value. Default value is 2000.}

\item{buffer_bp}{length of buffer in base pairs used to fit smoothing
curve near maximum distance and plot diagnostics. Default is 3000.}

\item{lags}{a vector indicating possible number of lagged CpGs for
estimation of transition probabilities.}

\item{BPPARAM}{a \code{BiocParallelParam} object to specify the parallel
backend. The default option is \code{BiocParallel::bpparam()} which will
automatically creates a cluster appropriate for the operating system.}

\item{degree}{'degree' argument for `loess` function}

\item{span}{'span' argument for `loess` function}

\item{...}{additional arguments passed into the `loess` function.}
}
\value{
a 'transitProbs' object. Postfixes rule in the output variables:
P(0|0) => '00'; P(0|1) => '01'; P(1|0) => '10'; P(1|1) => '11'.
}
\description{
This function first computes transition probilities
conditioning on CpG-CpG distance in each cell. Then the probs from
individual cells are smoothed over CpG-CpG distance using `loess`
with inverse-variance fitting.
}
\examples{

# load example data
data(cell_1, cell_2, cell_3)

# process the data to align with input format
library(dplyr)
df_1 <- cell_1 \%>\% mutate(meth = round(mc_count / total)) \%>\% select(chr, pos, meth)
df_2 <- cell_2 \%>\% mutate(meth = round(mc_count / total)) \%>\% select(chr, pos, meth)
df_3 <- cell_3 \%>\% mutate(meth = round(mc_count / total)) \%>\% select(chr, pos, meth)

# run tpEstimate
list <- list(df_1, df_2, df_3)
tpEstimate(list)

}
