% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolData.R
\name{poolData}
\alias{poolData}
\title{Pool single-cell file together into an HDF5-based SummarizedExperiment
object with sparse matrix representation.}
\usage{
poolData(
  cellFiles,
  sep,
  writeDir,
  chrNames,
  colData = NULL,
  sparseNAdrop = TRUE
)
}
\arguments{
\item{cellFiles}{Vector of character strings indicating single-cell file
paths you wish to pool into SE object(s). Cell files should be in BED-like
format, where the first 5 columns in each file must be: <chr>, <pos>, <strand>,
<meth_read>, <total_read>, in strict order. Each row contains info of one CpG.
Strand is assumed to be properly filpped. Cell files can be zipped ones in .gz
format.}

\item{sep}{the field separator character. Values on each line of cell file are
separated by this character.}

\item{writeDir}{A single character string indicating a folder directory where
you wish to store the processed SE object(s). The SE will be stored in HDF5 format.}

\item{chrNames}{Single or a vector of character strings representing chromosome
names in cell files. Only chromosomes listed in \code{selectChrs} will be
processed.}

\item{colData}{A DataFrame or data.frame object containing colData for the SE
object (applied to all chromosomes).}

\item{sparseNAdrop}{Logical value indicating whether or not to use NA-dropped
sparseMatrix representation. 'NA-dropped' means replacing NAs as zeros and
then represent 0 as a very small positive value close to 0 so that the data
matrix is converted to a traditional sparseMatrix form with 0 as default
entry value. (see \code{sparseNAMatrix-class} from package \code{recommenderlab}).
Using NA-dropped sparseMatrix representation helps to save RAM during data
processing, as well as storage space saving to disk. Currently only supports
TRUE!!}
}
\value{
Directly write out to the `writeDir` and does not return anything.
}
\description{
This function pools individual-cell CpG read files into a
SummarizedExperiment object so that it can be input to the \code{vmrseq.smooth}
function. Note that in each cell, sites with hemimethylation or intermediate
methylation levels (i.e., 0 < meth_read/total_read < 1) will be removed.
}
\examples{
\donttest{poolData(cellFiles = your_cell_file_list, sep = ",", chrNames = "chr1", writeDir = "your/write/path")}

}
