% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/characteriseGeneset.R
\name{characteriseGeneset}
\alias{characteriseGeneset}
\title{Functionally characterise a list of genes}
\usage{
characteriseGeneset(
  gs,
  thresh = 0.2,
  measure = c("ovlapcoef", "jaccard"),
  gscolcs = c("h", "c2", "c5"),
  org = c("auto", "hs", "mm")
)
}
\arguments{
\item{gs}{a GeneSet object, representing the list of genes that need to be
characterised.}

\item{thresh}{a numeric, specifying the threshold to discard pairs of gene
sets.}

\item{measure}{a character, specifying the similarity measure to use: \code{ari}
for the Adjusted Rand Index, \code{jaccard} for the Jaccard Index and
\code{ovlapcoef} for the Overlap Coefficient.}

\item{gscolcs}{a character, listing the MSigDB collections to use as a
background (defaults to h, c2, and c5). Collection types can be retrieved
using \code{\link[msigdb:listCollections]{msigdb::listCollections()}}.}

\item{org}{a character, specifying the organism to use. This can either be
"auto" (default), "hs" or "mm".}
}
\value{
an igraph object, containing gene sets that are similar to the query
set. The network contains relationships between results of the query too.
}
\description{
This function can be used to perform a network-based enrichment analysis of a
list of genes. The list of genes are characterised based on their similarity
with gene sets from the MSigDB. A network of similar gene sets is retrieved
using this function.
}
\examples{
library(GSEABase)
data(hgsc)

#create a geneset using one of the Hallmark gene sets
mySet <- GeneSet(
  geneIds(hgsc[[2]]),
  setName = 'MySet',
  geneIdType = SymbolIdentifier()
)

\donttest{
#characterise the custom gene set
ig <- characteriseGeneset(mySet)
plotMsigNetwork(ig)
}

}
