% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_coord_utils.R
\name{.fit_to_array_lsap}
\alias{.fit_to_array_lsap}
\title{Fit spots to a new Visium-like array: LSAP approach}
\usage{
.fit_to_array_lsap(coords, inter_spot_dist_px)
}
\arguments{
\item{coords}{A \code{data.frame()} containing capture areas of the
same group, and containing columns 'key', 'array_row', 'array_col',
'pxl_row_in_fullres', and 'pxl_col_in_fullres'.}

\item{inter_spot_dist_px}{\code{numeric(1)} vector giving the pixel distance
between any 2 spots in the new coordinates.}
}
\value{
A \link[dplyr:reexports]{tibble} with modified \code{array_row} + \code{array_col}
columns, as well as new \code{pxl_row_in_fullres_rounded} and
\code{pxl_col_in_fullres_rounded} columns representing the pixel coordinates
rounded to the nearest exact array coordinates.
}
\description{
Given transformed pixel coordinates, modify the 'array_row' and
'array_col' columns to represent a larger Visium capture area containing
all capture areas in a common coordinate system. The number of
array rows/cols generally changes from the Visium standards of 78 and 128
(and even may change in ratio between num rows and num cols).
}
\details{
Mapping to the proper array coordinates is framed as the linear sum
assignment problem, and solved using the Hungarian algorithm. This
approach is far slower than \code{.fit_to_array()}, running at O(n^3) with
the number of spots, but guarantees a one-to-one mapping of starting to
target spots, at a small cost in the Euclidean distance moved.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
