% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\docType{methods}
\name{bootstrapTtest}
\alias{bootstrapTtest}
\alias{bootstrapTtest,matrix-method}
\alias{bootstrapTtest,ExpressionSet-method}
\title{Bootstrapped signature by t-test}
\usage{
bootstrapTtest(x, ...)

\S4method{bootstrapTtest}{matrix}(x, y, per = 100, seed = 1,
  cores = 1, verbose = TRUE)

\S4method{bootstrapTtest}{ExpressionSet}(x, pheno, group1, group2,
  per = 100, seed = 1, verbose = TRUE)
}
\arguments{
\item{x}{Matrix containing the test dataset}

\item{...}{Additional parameters added to keep compatibility}

\item{y}{Matrix containing the reference dataset}

\item{per}{Integer indicating the number of permutations}

\item{seed}{Integer indicating the seed for the permutations, 0 for disable it}

\item{cores}{Integer indicating the number of cores to use (set to 1 in Windows-based systems)}

\item{verbose}{Logical whether progress should be reported}

\item{pheno}{Character string indicating the phenotype data to use}

\item{group1}{Vector of character strings indicating the category from phenotype \code{pheno} to use as test group}

\item{group2}{Vector of character strings indicating the category from phenotype \code{pheno} to use as control group}
}
\value{
Matrix of z-scores with genes in rows and permutations in columns
}
\description{
This function generates a bootstrapped signature matrix by t-test
}
\examples{
data(bcellViper, package="bcellViper")
d1 <- exprs(dset)
sig <- bootstrapTtest(d1[, 1:10], d1[, 11:20], per=100)
dim(sig)
plot(density(sig[1907, ]))
data(bcellViper, package="bcellViper")
sig <- bootstrapTtest(dset, "description", "CB", "N", per=100)
dim(sig)
plot(density(sig[1907, ]))
}
\seealso{
\code{\link{msviper}}
}
