% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsDEGmat.R
\name{vsDEGMatrix}
\alias{vsDEGMatrix}
\title{Differential gene expression matrix}
\usage{
vsDEGMatrix(
  data,
  padj = 0.05,
  d.factor = NULL,
  type = c("cuffdiff", "deseq", "edger"),
  title = TRUE,
  legend = TRUE,
  grid = TRUE,
  data.return = FALSE,
  grey.scale = FALSE,
  xaxis.text.size = 10,
  yaxis.text.size = 10,
  main.title.size = 15,
  legend.text.size = 10,
  legend.title.size = 12
)
}
\arguments{
\item{data}{output generated from calling the main routines of either
\code{cuffdiff}, \code{DESeq2}, or \code{edgeR} analyses. For
\code{cuffdiff}, this will be a \code{*_exp.diff} file. For \code{DESeq2},
this will be a generated object of class \code{DESeqDataSet}. For
\code{edgeR}, this will be a generated object of class \code{DGEList}.}

\item{padj}{a user defined adjusted \eqn{p}-value cutoff point. Defaults to
\code{0.05}.}

\item{d.factor}{a specified factor; for use with \code{DESeq2} objects only.
This input equates to the first parameter for the contrast argument when
invoking the \code{results()} function in \code{DESeq2}. Defaults to
\code{NULL}}

\item{type}{an analysis classifier to tell the function how to process the
data. Must be either \code{cuffdiff}, \code{deseq}, or \code{edger}.
\code{cuffdiff} must be used with \code{cuffdiff} data; \code{deseq} must
be used for \code{DESeq2} output; \code{edgeR} must be used with
\code{edgeR} data. See the \code{data} parameter for further details.}

\item{title}{display the main title of plot. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no title will display in plot.}

\item{legend}{display legend of plot. Logical; defaults to \code{TRUE}.
If set to \code{FALSE}, no legend will display in plot.}

\item{grid}{display major and minor axis lines. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no axis lines will display in plot.}

\item{data.return}{returns data output of plot. Logical; defaults to
\code{FALSE}. If set to \code{TRUE}, a data frame will also be called.
Assign to object for reproduction and saving of data frame. See final
example for further details.}

\item{grey.scale}{displays grey color scheme instead of blue if set to
\code{TRUE}. Logical; defaults to \code{FALSE}.}

\item{xaxis.text.size}{change the font size of the \code{x}-axis text.
Defaults to \code{10}.}

\item{yaxis.text.size}{change the font size of the \code{y}-axis text.
Defaults to \code{10}.}

\item{main.title.size}{change the font size of the plot title text.
Defaults to \code{15}.}

\item{legend.text.size}{change the font size of the legend body text.
Defaults to \code{10}.}

\item{legend.title.size}{change the font size of the legend title text.
Defaults to \code{12}.}
}
\value{
An object created by \code{ggplot}
}
\description{
This function allows you to visualize the number of differentially
expressed genes (DEG) at a given adjusted \eqn{P}-value for each
experimental treatment level. Higher color intensity correlates to a
higher number of DEGs.
}
\examples{
# cuffdiff example
data("df.cuff")
vsDEGMatrix(
     df.cuff, padj = 0.05, d.factor = NULL, type = "cuffdiff",
     title = TRUE, legend = TRUE, grid = TRUE
)

# DESeq2 example
data("df.deseq")
require(DESeq2)
vsDEGMatrix(
     df.deseq, padj = 0.05, d.factor = "condition", type = "deseq",
     title = TRUE, legend = TRUE, grid = TRUE
)

# edgeR example
data("df.edger")
require(edgeR)
vsDEGMatrix(
     df.edger, padj = 0.05, d.factor = NULL, type = "edger",
     title = TRUE, legend = TRUE, grid = TRUE
)

# Extract data frame from visualization
data("df.edger")
require(edgeR)
tmp <- vsDEGMatrix(
     df.edger, padj = 0.05, d.factor = NULL, type = "edger",
     title = TRUE, legend = TRUE, grid = TRUE, data.return = TRUE
)
df_deg <- tmp[[1]] ## or use tmp$data
head(df_deg)

# Show plot from object (see prior example for more details)
tmp[[2]] ## or use tmp$plot
}
\author{
Brandon Monier, \email{brandon.monier@sdstate.edu}
}
