% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalizeVariance}
\alias{normalizeVariance}
\title{Identify overdispersed genes by normalizing counts per million (CPM)
gene expression variance relative to transcriptome-wide expectations
(Modified from SCDE/PAGODA2 code)}
\usage{
normalizeVariance(
  cpm,
  gam.k = 5,
  alpha = 0.05,
  max.adjusted.variance = 1000,
  min.adjusted.variance = 0.001,
  verbose = TRUE,
  plot = FALSE,
  details = FALSE
)
}
\arguments{
\item{cpm}{Counts per million (CPM) matrix. Rows are genes, columns are cells.}

\item{gam.k}{Generalized additive model parameter; the dimension of the
basis used to represent the smooth term (default: 5)}

\item{alpha}{Significance threshold for overdispersed genes (default: 0.05)}

\item{max.adjusted.variance}{Ceiling on maximum variance after normalization
to prevent infinites (default: 1e3)}

\item{min.adjusted.variance}{Floor on minimum variance after normalization
(default: 1e-3)}

\item{verbose}{Boolean for verbosity setting (default: TRUE)}

\item{plot}{Boolean to plot mean variance plots before and after correction}

\item{details}{Boolean to return detailed data frame or names of genes
(default: FALSE)}
}
\value{
A list with two items: (1) an adjusted CPM matrix with the same
dimensions as the input and (2) a dataframe with the summary statistics for
each gene.
}
\description{
Normalizes gene expression magnitudes to with respect to its ratio to the
transcriptome-wide expectation as determined by local regression on
expression magnitude
}
\examples{
data(vel)
curr <- vel$current

normalizeDepth(curr)

}
