% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortCols.R
\docType{methods}
\name{sortCols}
\alias{sortCols}
\alias{sortCols,matrix-method}
\alias{sortCols,data.frame-method}
\alias{sortCols,varPartResults-method}
\title{Sort variance partition statistics}
\usage{
sortCols(
  x,
  FUN = median,
  decreasing = TRUE,
  last = c("Residuals", "Measurement.error"),
  ...
)

\S4method{sortCols}{matrix}(
  x,
  FUN = median,
  decreasing = TRUE,
  last = c("Residuals", "Measurement.error"),
  ...
)

\S4method{sortCols}{data.frame}(
  x,
  FUN = median,
  decreasing = TRUE,
  last = c("Residuals", "Measurement.error"),
  ...
)

\S4method{sortCols}{varPartResults}(
  x,
  FUN = median,
  decreasing = TRUE,
  last = c("Residuals", "Measurement.error"),
  ...
)
}
\arguments{
\item{x}{object returned by \code{extractVarPart()} or \code{fitExtractVarPartModel()}}

\item{FUN}{function giving summary statistic to sort by.  Defaults to median}

\item{decreasing}{logical.  Should the sorting be increasing or decreasing?}

\item{last}{columns to be placed on the right, regardless of values in these columns}

\item{...}{other arguments to sort}
}
\value{
data.frame with columns sorted by mean value, with Residuals in last column
}
\description{
Sort columns returned by \code{extractVarPart()} or \code{fitExtractVarPartModel()}
}
\examples{
# library(variancePartition)

library(BiocParallel)

# load simulated data:
# geneExpr: matrix of gene expression values
# info: information/metadata about each sample
data(varPartData)

# Specify variables to consider
# Age is continuous so we model it as a fixed effect
# Individual and Tissue are both categorical, so we model them as random effects
form <- ~ Age + (1 | Individual) + (1 | Tissue)

# Step 1: fit linear mixed model on gene expression
# If categorical variables are specified, a linear mixed model is used
# If all variables are modeled as continuous, a linear model is used
# each entry in results is a regression model fit on a single gene
# Step 2: extract variance fractions from each model fit
# for each gene, returns fraction of variation attributable to each variable
# Interpretation: the variance explained by each variable
# after correction for all other variables
varPart <- fitExtractVarPartModel(geneExpr, form, info)

# violin plot of contribution of each variable to total variance
# sort columns by median value
plotVarPart(sortCols(varPart))

}
