% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotPercentBars}
\alias{plotPercentBars}
\alias{plotPercentBars,matrix-method}
\alias{plotPercentBars,data.frame-method}
\alias{plotPercentBars,varPartResults-method}
\title{Bar plot of gene fractions}
\usage{
plotPercentBars(
  x,
  col = c(ggColorHue(ncol(x) - 1), "grey85"),
  genes = rownames(x),
  width = NULL,
  ...
)

\S4method{plotPercentBars}{matrix}(
  x,
  col = c(ggColorHue(ncol(x) - 1), "grey85"),
  genes = rownames(x),
  width = NULL,
  ...
)

\S4method{plotPercentBars}{data.frame}(
  x,
  col = c(ggColorHue(ncol(x) - 1), "grey85"),
  genes = rownames(x),
  width = NULL,
  ...
)

\S4method{plotPercentBars}{varPartResults}(
  x,
  col = c(ggColorHue(ncol(x) - 1), "grey85"),
  genes = rownames(x),
  width = NULL,
  ...
)
}
\arguments{
\item{x}{object storing fractions}

\item{col}{color of bars for each variable}

\item{genes}{name of genes to plot}

\item{width}{specify width of bars}

\item{...}{other arguments}
}
\value{
Returns ggplot2 barplot
}
\description{
Bar plot of fractions for a subset of genes
}
\examples{
# library(variancePartition)

library(BiocParallel)

# load simulated data:
# geneExpr: matrix of gene expression values
# info: information/metadata about each sample
data(varPartData)

# Specify variables to consider
form <- ~ Age + (1 | Individual) + (1 | Tissue)

# Fit model
varPart <- fitExtractVarPartModel(geneExpr, form, info)

# Bar plot for a subset of genes showing variance fractions
plotPercentBars(varPart[1:5, ])

# Move the legend to the top
plotPercentBars(varPart[1:5, ]) + theme(legend.position = "top")

}
