% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_sites.R
\name{sample_sites}
\alias{sample_sites}
\title{Generate binding sites from a motif.}
\usage{
sample_sites(motif, n = 100, use.freq = 1)
}
\arguments{
\item{motif}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{n}{\code{numeric(1)} Number of sites to generate.}

\item{use.freq}{\code{numeric(1)} If one, use regular motif matrix. Otherwise,
use respective \code{multifreq} matrix.}
}
\value{
\code{\link{XStringSet}} object.
}
\description{
Given probabilities for a sequence as represented by a motif, generate
random sequences with the same length as the motif.
}
\examples{
motif <- create_motif()
sites <- sample_sites(motif)

}
\seealso{
\code{\link[=create_sequences]{create_sequences()}}, \code{\link[=create_motif]{create_motif()}}, \code{\link[=add_multifreq]{add_multifreq()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
