% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swanderlust.R
\name{Rwanderlust}
\alias{Rwanderlust}
\title{R inplementation of wanderlust}
\usage{
Rwanderlust(data, s, l = 15, k = 15, num_graphs = 1,
  num_waypoints = 250, waypoints_seed = 123, flock_waypoints = 2,
  metric = "euclidean", voting_scheme = "exponential",
  band_sample = FALSE, partial_order = NULL, verbose = TRUE)
}
\arguments{
\item{data}{Input data matrix.}

\item{s}{Starting point ID.}

\item{l}{l nearest neighbours.}

\item{k}{k nearest neighbours, k < l.}

\item{num_graphs}{Number of repreated graphs.}

\item{num_waypoints}{Number of waypoints to guide the trajectory detection.}

\item{waypoints_seed}{The seed for reproducing the results.}

\item{flock_waypoints}{The number of times for flocking the waypoints, default is 2.}

\item{metric}{Distance calculation metric for nearest neighbour detection.}

\item{voting_scheme}{The scheme of voting.}

\item{band_sample}{Boolean, if band the sample}

\item{partial_order}{default NULL}

\item{verbose}{Boolean, if print the details}
}
\value{
a list containing Trajectory, Order, Waypoints
}
\description{
R inplementation of wanderlust
}
\examples{
set.seed(15)
shuffled_iris <- iris[sample(150, 150, replace = FALSE), ]
data <- shuffled_iris[,1:4]
data_label <- shuffled_iris[,5]
wishbone <- Rwanderlust(data = data, num_waypoints = 100, waypoints_seed = 2)
pd1 <- data.frame(id = wishbone$Trajectory, label=data_label, stringsAsFactors = FALSE)
pd2 <- data.frame(id = seq_along(row.names(data)), label=data_label, stringsAsFactors = FALSE)
#ggplot(pd1, aes(x=id, y=id, colour = label)) + geom_point() + theme_bw()
#ggplot(pd2, aes(x=id, y=id, colour = label)) + geom_point() + theme_bw()
}
\author{
Hao Chen
}

