% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkedTxome.R
\name{linkedTxpData}
\alias{linkedTxpData}
\alias{makeLinkedTxpData}
\title{Make linked transcript data (linked GRanges)}
\usage{
makeLinkedTxpData(
  digest,
  digestType = "sha256",
  indexName,
  txpData,
  source,
  organism,
  release,
  genome
)
}
\arguments{
\item{digest}{character string of the full digest of the
reference transcripts, see \code{inspectDigests()} with \code{fullDigest=TRUE}}

\item{digestType}{character string of the digest, default \code{"sha256"}}

\item{indexName}{a name for the \code{index} when storing the linkedTxpData,}

\item{txpData}{\emph{GRanges} providing information about ranges
representing the transcript sequences linked to \code{digest}}

\item{source}{the source of transcriptome, e.g. \code{denovo}.
See \code{makeLinkedTxome()} for more information on specifying source}

\item{organism}{organism (e.g. "Homo sapiens")}

\item{release}{release number (e.g. "27")}

\item{genome}{genome (e.g. "GRCh38", or "none")}
}
\value{
nothing, the function is run for its side effects
}
\description{
\code{linkedTxpData} allows the user to save relevant \emph{GRanges} transcript data
for identifying and updating transcript metadata in a persistent manner
across R sessions. It can be used in combination with \code{inspectDigests()}
and \code{updateMetadata()}.
This is a lightweight version of \code{linkedTxome} (see
\code{makeLinkedTxome()}), which requires specifying a GTF file for building a
\emph{TxDb} and optionally a FASTA file for sequence retrieval.)
}
\details{
The \code{txpData} object is saved in the \code{getTximetaBFC()} location,
appended with a 32-character substring of \code{digest}.
The tibble listing all \code{linkedTxpData} is named
\code{linkedTxpDataTbl} and is listed in the same location.
}
\examples{

novel <- data.frame(seqnames = paste0("chr", rep(1:22, each=500)),
  start = 1e6 + 1 + 0:499 * 1000, end = 1e6 + 1 + 0:499 * 1000 + 1000 - 1,
  strand = "+", tx_name = paste0("novel", 1:(22*500)), 
  gene_id = paste0("novel_gene", rep(1:(22*10), each=50)), 
type = "protein_coding")
novel_gr <- as(novel, "GRanges")
names(novel_gr) <- novel$tx_name

makeLinkedTxpData(
 digest = "43158f2c8e88e3acd77c22aee557625a6f1b6a5038cfc7deb5e64903892d8070",
 digestType = "sha256",
 indexName = "my_novel_txps",
 txpData = novel_gr,
 source = "novel", organism="Homo sapiens", 
 release="v1", genome="GRCh38"
)

# to clear the entire linkedTxome table
# (don't run unless you want to clear this table!)
# bfcloc <- getTximetaBFC()
# bfc <- BiocFileCache(bfcloc)
# bfcremove(bfc, bfcquery(bfc, "linkedTxpDataTbl")$rid)

}
