% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{.getChannelCentres}
\alias{.getChannelCentres}
\title{Find the centres of each of the wells in a given channel.}
\usage{
.getChannelCentres(plate, cMethod, channel, minSeparation = 2000)
}
\arguments{
\item{plate}{A \code{ddpcrPlate} object from which to extract the centres.}

\item{cMethod}{The classification method to use (in the form of a character
string).}

\item{channel}{An integer 1 or 2 corresponding to the channel of interest.}

\item{minSeparation}{The minimum distance required between two cluster
centres in order for us to assume that k-means found two distinct clusters.
Defaults to 2000.}
}
\value{
A list of data frames, where each data frame has information about
the centres in the channel of interest.
}
\description{
The plate should have been classified by k-means clustering.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
