% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{.classifyOnChannel}
\alias{.classifyOnChannel}
\title{K-means classify a list of data frames individually, where each data frame
comprises droplets that are negative in the same channels only.}
\usage{
.classifyOnChannel(
  cl,
  channel,
  centres = NULL,
  minSeparation = 2000,
  fullTable = TRUE
)
}
\arguments{
\item{cl}{List of data frames, where each data frame corresponds to a well
with droplets corresponding only to "NN" and "NP" or "NN" and "PN".}

\item{channel}{The channel on which to classify (1 or 2).}

\item{centres}{A data frame of centres. The data frame should have columns
\code{Ch1.Amplitude} and \code{Ch2.Amplitude} and row names corresponding
the cluster label, e.g. "NN", "NP", "PN" or "PP".}

\item{minSeparation}{The minimum distance required between two cluster
centres in order for us to assume that k-means found two distinct clusters.
Defaults to 2000.}

\item{fullTable}{Whether to return a full table or just a vector. Defaults
to `TRUE`}
}
\value{
A classification for \code{cl}.
}
\description{
K-means classify a list of data frames individually, where each data frame
comprises droplets that are negative in the same channels only.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
