% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_TRIP_without_ui.R
\name{run_TRIP}
\alias{run_TRIP}
\title{Run tripr analysis via R command line}
\usage{
run_TRIP(
  datapath = fs::path_package("extdata", "dataset", package = "tripr"),
  output_path = fs::path_home("Documents/tripr_output"),
  filelist = c("1_Summary.txt", "2_IMGT-gapped-nt-sequences.txt",
    "4_IMGT-gapped-AA-sequences.txt", "6_Junction.txt"),
  cell = "Bcell",
  throughput = "High Throughput",
  preselection = "1,4C:W",
  selection = "5",
  identity_range = "85:100",
  vgenes = "",
  dgenes = "",
  jgenes = "",
  cdr3_length_range = "",
  aminoacid = "",
  pipeline = "1",
  select_clonotype = "V Gene + CDR3 Amino Acids",
  highly_sim_params = paste0("1-1 2-1 3-1 4-1 5-1 6-1 7-1 8-1 9-1 10-1 11-1 ",
    "12-1 13-1 14-1 15-2 16-2 17-2 18-2 19-2 20-2 21-2 23-2 24-2 25-2 ",
    "26-2 27-2 28-2 29-3 30-3 31-3 32-3 33-3 34-3 35-3 36-3 37-3 38-3 ",
    "39-3 40-3 41-3 42-3 43-3 44-3 45-3 46-3 47-3 48-3 49-3 50-3,1,Yes"),
  shared_clonotypes_params = "reads,1,Yes",
  highly_shared_clonotypes_params = "reads,1,Yes",
  repertoires_params = "1,4,6",
  identity_groups = "85:97,97:99,99:100,100:100",
  multiple_values_params = "2:7,2:3,2:5,2:11",
  alignment_params = "1,both,1,2:20",
  mutations_params = "both,0.5,0.5,2:20"
)
}
\arguments{
\item{datapath}{(character) The directory where the folders of the data 
is located. Note that every sample of the dataset must have \strong{its 
own individual folder} and every sample folder must 
be in \strong{one root folder}. Note that \strong{every} file in the root 
folder will be used in the analysis. \cr
Supposedly the dataset is in user's \emph{Documents/} folder, one could use: 
\code{fs::path_home("Documents", "dataset")}, with the help of 
\link[fs]{path_home} function.
See the package vignette for more.}

\item{output_path}{(character) The directory where the output data will 
be stored. Please provide a valid path, ideally the same way as datapath
by using the \link[fs]{path_home} function. \cr
The default value points to \emph{Documents/tripr_output} directory.}

\item{filelist}{(character vector) The character vector of files of the IMGT 
output that will be used through the analysis from each sample.}

\item{cell}{(character) 'Bcell' (default) or 'Tcell'.}

\item{throughput}{(character) 'High Throughput' (default) or 
'Low Throughput'.}

\item{preselection}{(character) Preselection options: \cr
1 == Only take into account Functional V-Gene, \cr
2 == Only take into account CDR3 with no Special Characters (X,*,#,.), \cr
3 == Only take into account Productive Sequences, \cr
4 == Only take into account CDR3 with valid start/end landmarks., \cr
For Preselection option 4, select start/end landmarks.,\cr
Use the vertical line '|' to add more than one start or end landmarks,\cr
Use comma ',' to seperate the list of options, use semicolon ':' to 
seperate start and end landmarks.}

\item{selection}{(character) Selection options: \cr
5 == V-REGION identity % , \cr
6 == Select Specific V Gene , \cr
7 == Select Specific J Gene , \cr
8 == Select Specific D Gene , \cr
9 == Select CDR3 length range ,\cr
10 == Only select CDR3 containing specific amino-acid sequence. \cr
Use comma ',' to seperate the list of options.}

\item{identity_range}{(character) V-REGION identity %Low and %High, \cr
Use colon ':' to seperate identity low and high}

\item{vgenes}{(character) Filter in specific V Genes, \cr
Separate the different V-Gene names with '|' e.g. TRBV11-2|TRBV29-1*03 (F)}

\item{dgenes}{(character) Filter in specific D Genes, \cr
Separate the different D-Gene names with | e.g. TRBD2|TRBD1}

\item{jgenes}{(character) Filter in specific J Genes, \cr
Separate the different J-Gene names with | e.g. TRBJ2-6|TRBJ2-2}

\item{cdr3_length_range}{(character) Filter in rows with CDR3 lengths 
within a range, \cr
   Use colon ':' to seperate identity low and high}

\item{aminoacid}{(character) Filter in rows with CDR3 containing specific 
amino-acid sequence}

\item{pipeline}{(character) Pipeline options: \cr
1 == Clonotypes Computation, \cr
2 == Highly Similar Clonotypes computation, \cr
3 == Shared Clonotypes Computation, \cr
4 == Highly Similar Shared Clonotypes Computation, \cr
5 == Repertoires Extraction, \cr
6 == Repertoires Comparison, \cr
7 == Highly Similar Repertoires Extraction, \cr
8 == Insert Identity groups, \cr
9 == Somatic hypermutation status,  \cr
10 == CDR3 Distribution, \cr
11 == Pi Distribution, \cr
12 == Multiple value comparison, \cr
13 == CDR3 with 1 length difference, \cr
14 == Alignment, \cr
15 == Somatic hypermutations,  \cr
16 == Logo, \cr
17 == SHM normal, \cr
18 == SHM High similarity, \cr
19 == Diagnosis, \cr
Use comma ',' to seperate the list of options}

\item{select_clonotype}{(character) Compute clonotypes. \cr
Select one the following options: \cr
   "V Gene + CDR3 Amino Acids", \cr
   "V Gene and Allele + CDR3 Amino Acids", \cr
   "V Gene + CDR3 Nucleotide", \cr
   "V Gene and Allele + CDR3 Nucleotide", \cr
   "J Gene + CDR3 Amino Acids", \cr
   "J Gene and Allele + CDR3 Amino Acids", \cr
   "J Gene + CDR3 Nucleotide", \cr
   "J Gene and Allele + CDR3 Nucleotide", \cr
   "CDR3 Amino Acids", \cr
   "CDR3 Nucleotide", \cr
   "Sequence}

\item{highly_sim_params}{(character) Select number of missmatches, the 
threshold of 
the clonotype frequency and whether you want to take gene into account.
Use dashes '-' to show the length of the CDR3 sequences and the number 
of allowed missmatches and spaces ' ' to separate. For the CDR3 lengths 
with not specified number of missmatches the default value is 1.
Use comma ',' to separate the three options.}

\item{shared_clonotypes_params}{(character) Shared clonotypes computation.\cr
Select 'reads' of 'threshold' for clonotypes, the number of reads or 
the threshold percentage accordingly, and whether you want to take 
gene into account.
Use comma ',' to seperate the 3 options}

\item{highly_shared_clonotypes_params}{(character) Highly Similar Shared 
Clonotypes Computation \cr
 Select 'reads' of 'threshold' for clonotypes, the number of 
 reads or the threshold percentage accordingly, and whether you want 
 to take gene into account.
 Use comma ',' to seperate the 3 options}

\item{repertoires_params}{(character) Repertoires Extraction \cr
Options: \cr
1 == V Gene \cr
2 == V Gene and allele \cr
3 == J Gene \cr
4 == J Gene and allele \cr
5 == D Gene \cr
6 == D Gene and allele \cr
Use comma ',' to seperate the selected options}

\item{identity_groups}{(character) Insert identity groups \cr
Insert low and high values as follows: \cr
low_values:high_values \cr
Seperate low_values and high_values using comma ','.}

\item{multiple_values_params}{(character) Multiple value comparison \cr
   Options: \cr
   1 == V GENE   \cr
   2 == V GENE and allele \cr
   3 == J GENE  \cr
   4 == J GENE and allele \cr
   5 == D GENE  \cr
   6 == D GENE and allele \cr
   7 == CDR3-IMGT length  \cr
   8 == D-REGION reading frame \cr
   9 == Molecular mass \cr
   10 == pI  \cr
   11 == V-REGION identity %  \cr
   Use colon ':' to indicate combinations of 2 values, use comma "," to 
seperate the selected options}

\item{alignment_params}{(character) Alignment parameters: \cr
Region for Alignment: 1 == V.D.J.REGION or 2 == V.J.REGION  \cr
AA or Nt: Select 'aa' or 'nt' or 'both' \cr
Germline: 1 == Use Allele's germline or 2 == Use Gene's germline \cr
Use: 1 == All clonotypes or 2 == Select top N clonotypes or 3 == Select 
threshold for clonotypes  \cr
Use comma ',' to seperate the 4 parameters.
If you select option 2 or 3 at the 4th parameter you have to set 
the N or the threshold as well using colon ':'.}

\item{mutations_params}{(character) Somatic hypermutations parameters: \cr
AA or Nt: Select 'aa' or 'nt' or 'both'  \cr
Set threshold for AA \cr
Set threshold for Nt \cr
Use: 1 == All clonotypes or 2 == Select top N clonotypes or  
3 == Select threshold for clonotypes  \cr
Use comma ',' to seperate the 3 parameters.
If you select option 2 or 3 at the 3rd parameter you have to set 
the N or the threshold as well using colon ':'.}
}
\value{
None
}
\description{
\code{run_TRIP()} is a wrapper of \{tripr\} shiny analysis tool for use via R
 command line. 
Output of analysis is saved in \emph{tripr/extdata/output} folder, where R 
libraries are saved (typically \emph{R/library}).
}
\examples{


## Do not run

run_TRIP(
   output_path=tools::R_user_dir("tripr", which="cache"),
   filelist=c("1_Summary.txt", "2_IMGT-gapped-nt-sequences.txt", 
       "4_IMGT-gapped-AA-sequences.txt", "6_Junction.txt"),
   cell="Bcell", 
   throughput="High Throughput", 
   preselection="1,2,3,4C:W", 
   selection="5", 
   identity_range="88:100", 
   cdr3_length_range="", 
   pipeline="1", 
   select_clonotype="V Gene + CDR3 Amino Acids")


}
