% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_cycle_space.R
\name{project_cycle_space}
\alias{project_cycle_space}
\title{Project data into the cell cycle pattern space}
\usage{
project_cycle_space(
  x,
  exprs_values = "logcounts",
  altexp = NULL,
  name = "tricycleEmbedding",
  ref.m = NULL,
  gname = NULL,
  gname.type = c("ENSEMBL", "SYMBOL"),
  species = c("mouse", "human"),
  AnnotationDb = NULL
)
}
\arguments{
\item{x}{A numeric matrix of **log-expression** values where rows are features and columns are cells.
Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such a matrix.}

\item{exprs_values}{Integer scalar or string indicating which assay of \code{x} contains the **log-expression** values. Default: 'logcounts'}

\item{altexp}{String or integer scalar specifying an alternative experiment containing the input data.}

\item{name}{String specifying the name to be used to store the result in the \code{\link[SingleCellExperiment]{reducedDims}} of the output. Default: 'tricycleEmbedding'}

\item{ref.m}{A custom reference projection matrix to project the new data, where rows are features and columns are dimensions.
Users need to use the same type of \code{gname}(or rownames of \code{x}) as for the \code{ref.m}.
If no custom ref.m is given, the internal reference \code{neuroRef} will be used.}

\item{gname}{Alternative rownames of \code{x}. If provided, this will be used to map genes within \code{x} with genes in \code{ref.m}.
If not provided, the rownames of \code{x} will be used instead. Default: NULL}

\item{gname.type}{The type of gene names as in \code{gname} or rownames of \code{x}. It can be either 'ENSEMBL' or 'SYMBOL'. If the user uses
custom \code{ref.m}, this value will have no effect. Default: 'ENSEMBL'}

\item{species}{The type of species in \code{x}. It can be either 'mouse' or 'human'. If the user uses
custom \code{ref.m}, this value will have no effect. Default: 'mouse'}

\item{AnnotationDb}{An AnnotationDb objects. If the user uses the internal reference to project human data,
and provide rownames in the format of Ensembl IDs, this object will be used to map Ensembl IDs to gene SYMBOLs.
If no AnnotationDb object being given, the function will use \code{\link[org.Hs.eg.db]{org.Hs.eg.db}}.}
}
\value{
If the input is a numeric matrix or a \linkS4class{SummarizedExperiment}, a projection matrix with rows cells and column dimensions will be returned.
The actual rotation matrix used to project the data is included in the attributes with name 'rotation'.

For \linkS4class{SingleCellExperiment}, an updated \linkS4class{SingleCellExperiment} is returned containing projection matrix in \code{\link[SingleCellExperiment]{reducedDims}(..., name)}.
}
\description{
Project mouse and human single cell RNAseq data into a cell cycle embedding by a pre-learned reference projection matrix.
}
\details{
The function will use pre-learned cell cycle pattern to project new data to show the cell cycle progression. If the user uses internal Neuropshere reference,
the expression values must be **log-transformed**. Besides, we would assume the input data has been already preprocessed, library size normalized at least.
The projection process is to take sum of weighted mean-centered expression of chosen genes, so the mean expression of a given gene could be affected without library size normalization.
}
\examples{
data(neurosphere_example, package = "tricycle")
neurosphere_example <- project_cycle_space(neurosphere_example)
reducedDimNames(neurosphere_example)
head(reducedDim(neurosphere_example, "tricycleEmbedding"))
plot(reducedDim(neurosphere_example, "tricycleEmbedding"))
names(attributes(reducedDim(neurosphere_example, "tricycleEmbedding")))
}
\references{
Zheng SC, et al.
\emph{Universal prediction of cell cycle position using transfer learning.}
Genome Biology (2022) 23: 41
doi:\href{https://doi.org/10.1186/s13059-021-02581-y}{10.1186/s13059-021-02581-y}.
}
\seealso{
\code{\link{estimate_cycle_position}}, for inferring cell cycle position.
}
\author{
Shijie C. Zheng
}
