% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_periodic_loess.R
\name{fit_periodic_loess}
\alias{fit_periodic_loess}
\title{Fit periodic loess line with circular predictor}
\arguments{
\item{theta.v}{The cell cycle position - a numeric vector with range between 0 to 2pi.}

\item{y}{The response variable - a numeric vector with the same length as \code{theta.v}.}

\item{span}{The parameter \eqn{\alpha} which controls the degree of smoothing. See \code{\link[stats]{loess}}. Default: 0.3}

\item{length.out}{The number of data points on the fitted lines to be output in the prediction data.frame. Default: 200}

\item{plot}{If \code{TRUE}, a \code{ggplot} scatter plot will be included in the output list. The figure will plot y ~ theta.v 
with points and the fitted \code{\link[stats]{loess}} line. Default: FALSE}

\item{fig.title}{The title of the figure. Default: NULL}

\item{point.size}{The size of the point in scatter plot used by \code{\link[scattermore]{geom_scattermore}}. Default: 2.1}

\item{point.alpha}{The alpha value (transparency) of the point in scatter plot used by \code{\link[scattermore]{geom_scattermore}}. Default: 0.6}

\item{line.size}{The size of the fitted line, used by \code{\link[ggplot2]{geom_path}}. Default: 0.8}

\item{line.alpha}{The alpha value (transparency) of the fitted line, used by \code{\link[ggplot2]{geom_path}}. Default: 0.8}

\item{color.vars}{Optional. A vector of categorical variable of the same length of \code{theta.v}, and it will be used to color points in figure. Default: NULL}

\item{color.name}{The name of the color variables. Used as the name for legend. Default: NULL}

\item{x_lab}{Title of x-axis. Default: "\eqn{\theta}"}

\item{y_lab}{Title of y-axis. Default: "y"}

\item{hue.colors}{The string vector gives custom colors. If not given, the default \code{\link[ggplot2]{scale_color_discrete}} will be used. Default: NULL}

\item{...}{Other arguments input to \code{\link[stats]{loess}}.}
}
\value{
A list with the following elements:
\itemize{
  \item fitted - The fitted vaues on the loess line. A vector of the length of y.
  \item residual - The residual values from the fitted loess line, i.e. y - y.fit. A vector of the length of y.
  \item pred.df - The prediction \code{data.frame} by uniformly sampling theta from 0 - 2*pi. Names of variables: \code{x} and \code{y}. The number of rows equals to \code{length.out}.
  \item loess.o - The fitted loess object.
  \item rsquared -  The coefficient of determination R2. Calculated as 1 - residual sum of squares / the total sum of squares.
  \item fig - When \code{plot} is \code{TRUE}, a \code{ggplot} scatter plot object will be returned with other items.
}
}
\description{
The function will fit a loess line using cell cycle position and other variables, such as expression levels of a gene
 or log-transformed totalUMIs numbers. The circular nature of cell cycle position is taken into account by making 3 copies inside the function.
 For convenience, the function will also return a scatter plot with fitted line if needed.
}
\details{
This function fit a normal loess line, but take the circularity of cell cycle position into account by making \code{theta.v} 3 periods
(\code{c(theta.v - 2 * pi, theta.v, theta.v + 2 * pi)}) and repeating y 3 times. Only the fitted values corresponding to original \code{theta.v}
will be returned. For convenience, the function will also return a scatter plot with fitted line if needed. 
Or user can use \code{pred.df} to visualize the loess line themselves.
}
\examples{
data(neurosphere_example, package = "tricycle")
neurosphere_example <- estimate_cycle_position(neurosphere_example)
top2a.idx <- which(rowData(neurosphere_example)$Gene == "Top2a")
fit.l <- fit_periodic_loess(neurosphere_example$tricyclePosition,
 assay(neurosphere_example, "logcounts")[top2a.idx, ], plot = TRUE)
fit.l$fig
}
\seealso{
\code{\link{estimate_cycle_position}}, for inferring cell cycle position.
}
\author{
Shijie C. Zheng
}
