% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pca_cc_genes.R
\name{run_pca_cc_genes}
\alias{run_pca_cc_genes}
\title{Run PCA on Gene Ontology cell cycle genes}
\arguments{
\item{sce.o}{A \linkS4class{SingleCellExperiment} contains library size normalized **log-expression** matrix.}

\item{gname}{Alternative rownames of \code{sce.o}. If provided, this will be used to map genes within Gene Ontology cell cycle gene list.
If not provided, the rownames of \code{sce.o} will be used instead. Default: NULL}

\item{exprs_values}{Integer scalar or string indicating which assay of \code{sce.o} contains the **log-expression** values, which will be used to run PCA.
Default: 'logcounts'}

\item{gname.type}{The type of gene names as in \code{gname} or rownames of \code{sce.o}. It can be either 'ENSEMBL' or 'SYMBOL'. Default: 'ENSEMBL'}

\item{species}{The type of species in \code{sce.o}. It can be either 'mouse' or 'human'. If the user uses
custom \code{cycleGene.l}, this value will have no effect. Default: 'mouse'}

\item{AnnotationDb}{An AnnotationDb objects. It is used to map ENSEMBL IDs to gene SYMBOLs.
If no AnnotationDb object being given, the function will use \code{\link[org.Hs.eg.db]{org.Hs.eg.db}} or \code{\link[org.Mm.eg.db]{org.Mm.eg.db}} for human and mouse respectively.}

\item{ntop}{The number of genes with highest variance to use when calculating PCA, as in \code{\link[scater]{calculatePCA}}. Default: 500}

\item{ncomponents}{The number of component components to obtain, as in \code{\link[scater]{calculatePCA}}. Default: 20}

\item{name}{String specifying the name to be used to store the result in the \code{\link[SingleCellExperiment]{reducedDims}} of the output. Default: 'PCA'}
}
\value{
A subset \linkS4class{SingleCellExperiment} object with only GO cell cycle genes will be return.
The PCA resulting will be save in reducedDims with chosen name \code{\link[SingleCellExperiment]{reducedDims}(..., name)}.
If Seurat integration is performed, another reducedDims with name 'matched.'+\code{name} will also be included in the \linkS4class{SingleCellExperiment}.
}
\description{
Run PCA on Gene Ontology cell cycle genes abd get a new \linkS4class{SingleCellExperiment}.
User could use this function to learn new reference projection matrix.
}
\details{
The function require an output of a \linkS4class{SingleCellExperiment} object which contains the library size normalized **log-expression** matrix. The full dataset will
be subsetted to genes in the Gene Ontology cell cycle gene list (GO:0007049). The corresponding AnnotationDb object will be
 \code{\link[org.Mm.eg.db]{org.Mm.eg.db}} and \code{\link[org.Hs.eg.db]{org.Hs.eg.db}} for mouse and human respectively. If \code{runSeuratBy} is set, the data will be
 integrated to remove batch effect between samples/batches by Seurat.

User can use this function to make new reference projection matrix by getting the 'rotation' attribute in PCA results. Such as
\code{attr(reducedDim(sce.o, 'PCA'), 'rotation')[, 1:2]}. See examples for more details.
}
\examples{
data(neurosphere_example, package = "tricycle")
### Use internal NeuroRef to project and infer tricyclePosition
neurosphere_example <- estimate_cycle_position(neurosphere_example) 

### Build new reference
gocc_sce.o <- run_pca_cc_genes(neurosphere_example)
new.ref <- attr(reducedDim(gocc_sce.o, "PCA"), "rotation")[, seq_len(2)]

### Use new reference to project and infer tricyclePosition
new_sce <- estimate_cycle_position(neurosphere_example, ref.m = new.ref,
 dimred = "tricycleEmbedding2")
plot(neurosphere_example$tricyclePosition, new_sce$tricyclePosition)
}
\author{
Shijie C. Zheng
}
