% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjFromExons.R
\name{sjFromExons}
\alias{sjFromExons}
\title{Obtain Splice-Junctions from Exons and Transcripts}
\usage{
sjFromExons(
  x,
  rank_col = c("exon_number", "exon_rank"),
  tx_col = c("transcript_id", "tx_id"),
  extra_cols = "all",
  don_len = 8,
  acc_len = 5,
  as = c("GRanges", "GInteractions"),
  ...
)
}
\arguments{
\item{x}{GRanges object with exons and transcripts. A column indicating the
position (or rank) of each exon within the transcript must be included.}

\item{rank_col}{The column containing the position of each exons within the
transcript}

\item{tx_col}{The column containing unique transcript-level identifiers}

\item{extra_cols}{Can be a vector of column names to return beyond rank_col
and tx_col. By default all columns are returned (extra_cols = "all").}

\item{don_len, acc_len}{Length of donor and acceptor sites respectively}

\item{as}{Return as a set of GenomicRanges, or with each splice junction
annotated as a GenomicInteraction}

\item{...}{Not used}
}
\value{
A GRanges object with requested columns, and an additional column, 'site',
annotating each region as a donor or acceptor site.

Alternatively, by specifying as = "GInteractions", the junctions can be
returned with each splice junction annotated as a GenomicInteraction.
This can make the set of junctions easier to interpret for a given
transcript.
}
\description{
Using GRanges defining exons and transcripts, find the splice-junctions
}
\details{
A canonical splice junction consists of a donor site and an acceptor site at
each end of an intron, with a branching site somewhere wthin the intron.
Canonical donor sites are 8nt long with the the first two bases being exonic
and the next 6 being derived form intronic sequences.
Canonical acceptor sites are 5nt long with the first four bases being
intronic and the final base being the first base of the next exon.

This functions uses each set of exons within a transcript to identify both
donor and acceptor sites. Branch sites are not identified.
}
\examples{
library(rtracklayer)
gtf_cols <- c(
  "transcript_id", "transcript_name", "gene_id", "gene_name", "exon_number"
)
gtf <- import.gff(
   system.file("extdata/gencode.v44.subset.gtf.gz", package = "transmogR"),
   feature.type = "exon", colnames = gtf_cols
)
sj <- sjFromExons(gtf)
sj

## Or to simplify shared splice junctions across multiple transcripts
library(extraChIPs, quietly = TRUE)
chopMC(sj)

## Splice Junctions can also be returned as a GInteractions object with
## anchorOne as the donor & anchorTwo as the acceptor sites
sjFromExons(gtf, as = "GInteractions")


}
