% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{estimate_significance}
\alias{estimate_significance}
\title{Permutation Test Based Significance of Observed Mean}
\usage{
estimate_significance(
  actual_mean,
  motif_kmers,
  random_permutations,
  alternative = c("two_sided", "less", "greater"),
  conf_level = 0.95,
  produce_plot = TRUE
)
}
\arguments{
\item{actual_mean}{observed mean}

\item{motif_kmers}{set of \emph{k}-mers that were used to compute
the \code{actual_mean}}

\item{random_permutations}{a set of random permutations of the
original data, used
to generate an empirical null distribution.}

\item{alternative}{side of the test, one of the following:
\code{"two_sided"},
\code{"less"}, \code{"greater"}}

\item{conf_level}{confidence level for the returned confidence interval}

\item{produce_plot}{if distribution plot should be part of the
returned list}
}
\value{
A list with the following components:
\tabular{rl}{
  \code{p_value_estimate} \tab the estimated p-value of the
  observed mean\cr
  \code{conf_int} \tab the confidence interval around that estimate\cr
  \code{plot} \tab plot of the empirical distribution of
  geometric means of the
  enrichment values
}
}
\description{
\code{estimate_significance} returns an estimate of the significance
of the observed
mean, given a set of random permutations of the data.
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{create_kmer_origin_list}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
