% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-generics.R, R/ChipDataSet-methods.R
\docType{methods}
\name{getGenomicAnnot}
\alias{getGenomicAnnot}
\alias{getGenomicAnnot,ChipDataSet-method}
\title{getGenomicAnnot}
\usage{
getGenomicAnnot(object)

\S4method{getGenomicAnnot}{ChipDataSet}(object)
}
\arguments{
\item{object}{A \code{\link{ChipDataSet}} object.}
}
\value{
A four column \code{Data.Frame}, storing information about observed and
    expected number of peaks at distinct genomic features.
}
\description{
Retrieve genomic distribution of ChIP-seq peaks at distinct genomic features
(exons, introns, TSSs, intergenic regions)
}
\details{
A simple quality check of the supplied ChIP-seq peaks can be performed by
    investigating their genomic distribution. Ideally, these peaks should
    demonstrate substantial enrichment at TSS regions. Enrichment of the
    peaks at a given genomic feature (e.g. TSS) is defined as the ratio
    between the observed and expected number of peaks. The expected number of
    peaks is calculated from the proportion of the genome covered by the
    given genomic feature.
}
\examples{
### Load ChipDataSet object
data(cds)

getGenomicAnnot(cds)

}
\seealso{
\code{\link{constructCDS}}
}
\author{
Armen R. Karapetyan
}
