% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{igvParam}
\alias{igvParam}
\alias{igvParam-class}
\title{Parameters for displaying bigwigs, bams and intervals in IGV}
\usage{
igvParam(bigwig.altColor = "darkgrey", bigwig.color = "darkgrey",
  bigwig.autoScale = "true", bigwig.displayMode = "COLLAPSED",
  bigwig.featureVisibilityWindow = -1, bigwig.fontSize = 10,
  bigwig.normalize = "false", bigwig.renderer = "BAR_CHART",
  bigwig.sortable = "true", bigwig.visible = "true",
  bigwig.windowFunction = "mean", bigwig.baseline = 0,
  bigwig.drawBaseline = "true", bigwig.flipAxis = "false",
  bigwig.maximum = 50, bigwig.minimum = 0, bigwig.type = "LINEAR",
  interval.altColor = "darkgrey", interval.color = "darkgrey",
  interval.autoScale = "true", interval.displayMode = "character",
  interval.featureVisibilityWindow = -1, interval.fontSize = 10,
  interval.height = 40, interval.normalize = "false",
  interval.renderer = "BASIC_FEATURE", interval.sortable = "true",
  interval.visible = "true", interval.windowFunction = "count",
  bam.altColor = "darkgrey", bam.color = "darkgrey",
  bam.autoScale = "true", bam.displayMode = "EXPANDED",
  bam.featureVisibilityWindow = -1, bam.fontSize = 10,
  bam.showSpliceJunctions = "false", bam.colorByTag = "",
  bam.colorOption = "UNEXPECTED_PAIR", bam.flagUnmappedPairs = "false",
  bam.groupByTag = "", bam.maxInsertSize = 1000, bam.minInsertSize = 50,
  bam.shadeBasesOption = "QUALITY", bam.shadeCenters = "true",
  bam.showAllBases = "false", bam.sortByTag = "")

igvParam(bigwig.altColor = "darkgrey", bigwig.color = "darkgrey",
  bigwig.autoScale = "true", bigwig.displayMode = "COLLAPSED",
  bigwig.featureVisibilityWindow = -1, bigwig.fontSize = 10,
  bigwig.normalize = "false", bigwig.renderer = "BAR_CHART",
  bigwig.sortable = "true", bigwig.visible = "true",
  bigwig.windowFunction = "mean", bigwig.baseline = 0,
  bigwig.drawBaseline = "true", bigwig.flipAxis = "false",
  bigwig.maximum = 50, bigwig.minimum = 0, bigwig.type = "LINEAR",
  interval.altColor = "darkgrey", interval.color = "darkgrey",
  interval.autoScale = "true", interval.displayMode = "character",
  interval.featureVisibilityWindow = -1, interval.fontSize = 10,
  interval.height = 40, interval.normalize = "false",
  interval.renderer = "BASIC_FEATURE", interval.sortable = "true",
  interval.visible = "true", interval.windowFunction = "count",
  bam.altColor = "darkgrey", bam.color = "darkgrey",
  bam.autoScale = "true", bam.displayMode = "EXPANDED",
  bam.featureVisibilityWindow = -1, bam.fontSize = 10,
  bam.showSpliceJunctions = "false", bam.colorByTag = "",
  bam.colorOption = "UNEXPECTED_PAIR", bam.flagUnmappedPairs = "false",
  bam.groupByTag = "", bam.maxInsertSize = 1000, bam.minInsertSize = 50,
  bam.shadeBasesOption = "QUALITY", bam.shadeCenters = "true",
  bam.showAllBases = "false", bam.sortByTag = "")
}
\arguments{
\item{bigwig.altColor}{A character vector of alternate colour for bigwigs displayed in IGV.}

\item{bigwig.color}{A character vector of main colour for bigwigs displayed in IGV.}

\item{bigwig.displayMode}{A character vector of display mode for bigwigs displayed in IGV.}

\item{bigwig.featureVisibilityWindow}{A numeric vector of feature visibility window for bigwigs displayed in IGV (Defaut -1).}

\item{bigwig.fontSize}{A numeric vector of font size for bigwigs displayed in IGV.}

\item{bigwig.autoScale}{A character vector ("true"/"false") to indicate whether data is autoscaled for bigwigs displayed in IGV (Default "true").}

\item{bigwig.normalize}{A character vector ("true"/"false") to indicate whether data is normalised for bigwigs displayed in IGV (Default "false").}

\item{bigwig.renderer}{A character vector of renderer for bigwigs displayed in IGV (Default "BAR_CHART").}

\item{bigwig.sortable}{A character vector ("true"/"false") to indicate whether data is sortable for bigwigs displayed in IGV (Default "true").}

\item{bigwig.visible}{A character vector ("true"/"false") to indicate whether data is visible for bigwigs displayed in IGV (Default "true").}

\item{bigwig.windowFunction}{A character vector ("true"/"false") of window function for bigwigs displayed in IGV (Default "mean").}

\item{bigwig.baseline}{A numeric vector of baseline bigwigs displayed in IGV.}

\item{bigwig.drawBaseline}{A character vector ("true"/"false") of whether to draw baseline for bigwigs displayed in IGV (Default "true").}

\item{bigwig.flipAxis}{A character vector ("true"/"false") to indicate whether to flip axis for bigwigs displayed in IGV (Default "false").}

\item{bigwig.maximum}{A numeric vector of maximum value to display for bigwigs displayed in IGV (Default 50).}

\item{bigwig.minimum}{A numeric vector of minimum value to display for bigwigs displayed in IGV (Default 0).}

\item{bigwig.type}{A character vector of display type for bigwigs displayed in IGV (Default "LINEAR").}

\item{interval.altColor}{A character vector of alternate colour for intervals displayed in IGV.}

\item{interval.color}{A character vector of main colour for intervals displayed in IGV.}

\item{interval.autoScale}{A character vector ("true"/"false") to indicate whether data is autoscaled for intervals displayed in IGV (Default "false").}

\item{interval.displayMode}{A character vector of display mode for intervals displayed in IGV (Default "COLLAPSED").}

\item{interval.featureVisibilityWindow}{A numeric vector of feature visibility window for intervals displayed in IGV (Defaut -1).}

\item{interval.fontSize}{A numeric vector of font size for intervals displayed in IGV.}

\item{interval.height}{A numeric vector of height for intervals displayed in IGV.}

\item{interval.normalize}{A character vector ("true"/"false") to indicate whether data is normalised for intervals displayed in IGV (Default "false").}

\item{interval.renderer}{A character vector of renderer for intervals displayed in IGV (Default "BASIC_FEATURE").}

\item{interval.sortable}{A character vector ("true"/"false") to indicate whether data is sortable for intervals displayed in IGV (Default "true").}

\item{interval.visible}{A character vector ("true"/"false") to indicate whether data is visible for intervals displayed in IGV (Default "true").}

\item{interval.windowFunction}{A character vector ("true"/"false") of window function for intervals displayed in IGV (Default "count").}

\item{bam.altColor}{A character vector of alternate colour for bam files displayed in IGV.}

\item{bam.color}{A character vector of main colour for bam files displayed in IGV.}

\item{bam.autoScale}{A character vector ("true"/"false") to indicate whether data is autoscaled for bam files displayed in IGV (Default "false").}

\item{bam.displayMode}{A character vector of display mode for bam files displayed in IGV (Default "EXPANDED").}

\item{bam.featureVisibilityWindow}{A numeric vector of feature visibility window for bam files displayed in IGV (Defaut -1).}

\item{bam.fontSize}{A numeric vector of font size for intervals displayed in IGV.}

\item{bam.showSpliceJunctions}{A character vector ("true"/"false") to indicate whether to show splice juntions for bam files displayed in IGV (Default "false").}

\item{bam.colorByTag}{A character vector to indicate whether to colour reads by Tags for Bam files (Defualt = "").}

\item{bam.colorOption}{A character vector of option to highlight Tags for Bam files (Defualt = "UNEXPECTED_PAIR").}

\item{bam.flagUnmappedPairs}{A character vector ("true"/"false") to indicate whether to flaf unmapped pairs for bam files displayed in IGV (Default "false").}

\item{bam.groupByTag}{A character vector ("true"/"false") to indicate how to groups reads by Tag for bam files displayed in IGV (Default "").}

\item{bam.maxInsertSize}{A numeric vector of maximum insert size to display for Bam files.}

\item{bam.minInsertSize}{A numeric vector of minimum insert size to display for Bam files.}

\item{bam.shadeBasesOption}{A character vector of option to shade bases for Bam files (Default "QUALITY").}

\item{bam.shadeCenters}{A character vector ("true"/"false") to indicate whether to shade centres for bam files displayed in IGV (Default "false").}

\item{bam.showAllBases}{A character vector ("true"/"false") to indicate to show all bases for bam files displayed in IGV (Default "false").}

\item{bam.sortByTag}{A character vector ("true"/"false") to indicate how to sort reads by Tag for bam files displayed in IGV (Default "").}
}
\value{
An igvParam class object to use with maketracktable,MakeIGVSession and makeIGVSessionMXL
}
\description{
Use igvParam( object)) to create a parameter object to control IGV display invoked from maketracktable() report or
from makeIGVSession() XML files. Parameters for bigwig, bam and intervals files may be provided. See IGV manual for a full
description of options.
}
\examples{
## Simple initialisation of an IGVParam object
igvDisplayParams <- igvParam()


## More custom initialisation of an IGVParam object .
igvDisplayParams <- igvParam(bigwig.color="red",bigwig.autoScale = "false",
bigwig.minimum = 10,bigwig.maximum = 100)


# See full parameters and IGV online manual for more details on customistions


## Use igvParams with maketracktables function to customise bigwig display colour and data range.
fileLocations <- system.file("extdata",package="tracktables")

bigwigs <- dir(fileLocations,pattern="*.bw",full.names=TRUE)

intervals <- dir(fileLocations,pattern="*.bed",full.names=TRUE)

bigWigMat <- cbind(gsub("_Example.bw","",basename(bigwigs)),
                   bigwigs)

intervalsMat <- cbind(gsub("_Peaks.bed","",basename(intervals)),
                      intervals)

fileSheet <- merge(bigWigMat,intervalsMat,all=TRUE)

fileSheet <- as.matrix(cbind(fileSheet,NA))

colnames(fileSheet) <- c("SampleName","bigwig","interval","bam")

SampleSheet <- cbind(as.vector(fileSheet[,"SampleName"]),
                     c("EBF","H3K4me3","H3K9ac","RNAPol2"),
                     c("ProB","ProB","ProB","ProB"))

colnames(SampleSheet) <- c("SampleName","Antibody","Species")
MakeIGVSession(SampleSheet,fileSheet,
igvdirectory=getwd(),"Example","mm9",
igvParams=igvDisplayParams)
}
\author{
Thomas Carroll
}

