% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIdeogram.R
\name{loadIdeogram}
\alias{loadIdeogram}
\title{load ideogram from UCSC}
\usage{
loadIdeogram(genome, chrom = NULL, ranges = NULL, ...)
}
\arguments{
\item{genome}{Assembly name  assigned by UCSC, such as hg38, mm10.}

\item{chrom}{A character vector of chromosome names, or NULL.}

\item{ranges}{A \link[IRanges:IRanges-class]{Ranges} object with the intervals.}

\item{...}{Additional arguments to pass to the 
\link[GenomicRanges:GRanges-class]{GRanges} constructor.}
}
\value{
A \link[GenomicRanges:GRanges-class]{GRanges} object.
}
\description{
Download ideogram table from UCSC
}
\examples{
\dontrun{
head(loadIdeogram("hg38", chrom = "chr1"))
}


}
\seealso{
See Also as \code{\link{ideogramPlot}}
}
