% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{topdownr-package}
\alias{topdownr}
\alias{topdownr-package}
\title{Investigation of Fragmentation Conditions in Top-Down Proteomics}
\description{
The topdownr package allows automatic and systemic investigation of
fragment conditions. It creates Thermo Orbitrap Fusion Lumos method files
to test hundreds of fragmentation conditions. Additionally it provides
functions to analyse and process the generated MS data and determine the
best conditions to maximise overall fragment coverage.
}
\details{
The usage of the topdownr package is demonstrated in the following vignettes:
\itemize{
\item Generate .meth files prior data acquisition for the Thermo Orbitrap Fusion
Lumos MS devise: \code{vignette("data-generation", package="topdownr")}.
\item How to analyse top-down fragmenation data:
\code{vignette("analysis", package="topdownr")}
}
}
\references{
\url{https://codeberg.org/sgibb/topdownr/}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://codeberg.org/sgibb/topdownr/}
  \item Report bugs at \url{https://codeberg.org/sgibb/topdownr/issues/}
}

}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de},
Pavel Shliaha \email{pavels@bmb.sdu.dk},
Ole Nørregaard Jensen \email{jenseno@bmb.sdu.dk}
}
\keyword{package}
