% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment-functions.R
\name{expandMs1Conditions}
\alias{expandMs1Conditions}
\alias{expandTms2Conditions}
\title{Expand MS Conditions}
\usage{
expandMs1Conditions(..., family = "Calcium", version = "3.2")

expandTms2Conditions(
  ActivationType = c("CID", "HCD", "ETD", "UVPD"),
  ...,
  MassList = NULL,
  family = "Calcium",
  version = "3.2"
)
}
\arguments{
\item{...}{further named arguments, used to create the combination of
conditions.}

\item{family}{\code{character}, currently just Calcium is supported}

\item{version}{\code{character}, currently 3.1, 3.2 (default), 3.3 are supported}

\item{ActivationType}{\code{character}, \emph{ActivationType} for TMS2,
either CID, HCD, ETD, or UVPD.}

\item{MassList}{\code{matrix}, 2 columns (mass, z) for targeted mass list,
or \code{NULL} (default) to not overwrite targeted mass.}
}
\value{
\code{data.frame} with all possible combinations of conditions/settings.
}
\description{
Create a \code{data.frame} of all possible combinations of the given arguments.
It ensures that just arguments are applied that yield a valid
MethodModification.xml file.
}
\examples{
expandMs1Conditions(FirstMass=100, LastMass=400)
expandTms2Conditions(
     ActivationType="CID",
     OrbitrapResolution="R120K",
     IsolationWindow=1,
     MaxITTimeInMS=200,
     Microscans=as.integer(40),
     AgcTarget=c(1e5, 5e5, 1e6),
     CIDCollisionEnergy=c(NA, seq(7, 35, 7)),
     MassList=cbind(mz=c(560.6, 700.5, 933.7), z=rep(1, 3))
)
}
\seealso{
\code{\link[=validMs1Settings]{validMs1Settings()}}

\code{\link[=validTms2Settings]{validTms2Settings()}}, \code{\link[=expand.grid]{expand.grid()}}
}
