% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment-functions.R
\name{createExperimentsFragmentOptimisation}
\alias{createExperimentsFragmentOptimisation}
\title{Create fragment optimisation experiment}
\usage{
createExperimentsFragmentOptimisation(
  ms1,
  ...,
  groupBy = c("AgcTarget", "replication"),
  nMs2perMs1 = 10,
  scanDuration = 0,
  replications = 2,
  randomise = TRUE
)
}
\arguments{
\item{ms1}{\code{data.frame}, MS1 settings.}

\item{...}{further named arguments with \code{data.frame}s containing the TMS2
settings.}

\item{groupBy}{\code{character}, group experiments by columns in the TMS2
\code{data.frame}s. The columns have to be present in all \code{data.frame}s. Each
group will be written to its own XML file.}

\item{nMs2perMs1}{\code{integer}, how many TMS2 scans should be run after a MS1
scan?}

\item{scanDuration}{\code{double}, if greater than zero (e.g. \code{scanDuration=0.5})
the Start/EndTimeMin are overwritten with a duration of \code{scanDuration}. If
\code{scanDuration} is zero (default) Start/EndTimeMin are not overwritten.}

\item{replications}{\code{integer}, number of replications.}

\item{randomise}{\code{logical}, should the TMS2 scan settings randomised?}
}
\value{
\code{list}, able to be written via \code{\link[xml2:as_xml_document]{xml2::as_xml_document()}}
}
\description{
This function is used to create a tree-like \code{list} of
all combinations of a user-given set of MS1 and TMS2 settings for an
fragment optimisation experiment. The list could be written to an
Orbitrap Fusion Lumos method xml file using \code{\link[=writeMethodXmls]{writeMethodXmls()}}.
}
\examples{
## build experiments within R
ms1 <- expandMs1Conditions(
    FirstMass=400,
    LastMass=1200,
    Microscans=as.integer(10)
)

targetMz <- cbind(mz=c(560.6, 700.5, 933.7), z=rep(1, 3))
common <- list(
    OrbitrapResolution="R120K",
    IsolationWindow=1,
    MaxITTimeInMS=200,
    Microscans=as.integer(40),
    AgcTarget=c(1e5, 5e5, 1e6)
)

cid <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="CID",
    CIDCollisionEnergy=seq(7, 35, 7)
)
hcd <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="HCD",
    HCDCollisionEnergy=seq(7, 35, 7)
)
etd <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="ETD",
    ETDReactionTime=as.double(1:2)
)
etcid <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="ETD",
    ETDReactionTime=as.double(1:2),
    ETDSupplementalActivation="ETciD",
    ETDSupplementalActivationEnergy=as.double(1:2)
)
uvpd <- expandTms2Conditions(
    MassList=targetMz,
    common,
    ActivationType="UVPD"
)

exps <- createExperimentsFragmentOptimisation(
    ms1=ms1, cid, hcd, etd, etcid, uvpd,
    groupBy=c("AgcTarget", "replication"), nMs2perMs1=10, scanDuration=0.5,
    replications=2, randomise=TRUE
)

## use different settings for CID
cid560 <- expandTms2Conditions(
    MassList=cbind(560.6, 1),
    common,
    ActivationType="CID",
    CIDCollisionEnergy=seq(7, 21, 7)
)
cid700 <- expandTms2Conditions(
    MassList=cbind(700.5, 1),
    common,
    ActivationType="CID",
    CIDCollisionEnergy=seq(21, 35, 7)
)

exps <- createExperimentsFragmentOptimisation(
    ms1=ms1, cid560, cid700,
    groupBy=c("AgcTarget", "replication"), nMs2perMs1=10, scanDuration=0.5,
    replications=2, randomise=TRUE
)

## use a CSV (or excel) file as input
myCsvContent <- "
ActivationType, ETDReactionTime, UVPDActivationTime
UVPD,,1000
ETD,1000,
"
myCsvSettings <- read.csv(text=myCsvContent, stringsAsFactors=FALSE)
myCsvSettings
#   ActivationType ETDReactionTime UVPDActivationTime
# 1           UVPD              NA               1000
# 2            ETD            1000                 NA

exps <- createExperimentsFragmentOptimisation(
    ms1 = data.frame(FirstMass=500, LastMass=1000),
    ## TMS2
    myCsvSettings,
    ## other arguments
    groupBy="ActivationType"
)
}
\seealso{
\code{\link[=writeMethodXmls]{writeMethodXmls()}},
\code{\link[=expandMs1Conditions]{expandMs1Conditions()}},
\code{\link[=expandMs1Conditions]{expandTms2Conditions()}}
}
